<?php
session_start();
require_once "../../config/db.php";
require_once "../../helpers/functions.php";

// Habilitar errores (solo en desarrollo)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 1) Obtener datos del formulario
    $id       = $_POST['id'] ?? null;
    $username = trim($_POST['username'] ?? '');
    $email    = trim($_POST['email'] ?? '');
    $nombre   = trim($_POST['nombre'] ?? '');
    $apellido = trim($_POST['apellido'] ?? '');
    $user_type = $_POST['user_type'] ?? '0';
    
    // Obtener valores de contraseña (opcional)
    $new_password = $_POST['password'] ?? '';
    $password_confirm = $_POST['password_confirm'] ?? '';
    
    // Validar el id
    if (!$id) {
        redirect('index.php?error=MissingID');
    }
    
    // 2) Si se ingresó nueva contraseña, validarla
    $updatePassword = false;
    if ($new_password !== '' || $password_confirm !== '') {
        if ($new_password !== $password_confirm) {
            redirect("edit.php?id=$id&error=1"); // Contraseñas no coinciden
        }
        // Crear el hash de la nueva contraseña
        $passwordHash = password_hash($new_password, PASSWORD_DEFAULT);
        $updatePassword = true;
    }
    
    // 3) Construir la consulta SQL según si se actualiza la contraseña o no
    if ($updatePassword) {
        $sql = "UPDATE users 
                SET username = :username, email = :email, nombre = :nombre, apellido = :apellido, user_type = :user_type, password = :password, updated_at = NOW() 
                WHERE id = :id";
        $params = [
            'username'  => $username,
            'email'     => $email,
            'nombre'    => $nombre,
            'apellido'  => $apellido,
            'user_type' => $user_type,
            'password'  => $passwordHash,
            'id'        => $id
        ];
    } else {
        $sql = "UPDATE users 
                SET username = :username, email = :email, nombre = :nombre, apellido = :apellido, user_type = :user_type, updated_at = NOW() 
                WHERE id = :id";
        $params = [
            'username'  => $username,
            'email'     => $email,
            'nombre'    => $nombre,
            'apellido'  => $apellido,
            'user_type' => $user_type,
            'id'        => $id
        ];
    }
    
    // 4) Ejecutar la actualización
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        // Redirigir a index.php con mensaje de éxito
        redirect("index.php?success=update");
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
        exit;
    }
} else {
    redirect('index.php');
}
?>
