<?php
session_start();
require_once "../../config/db.php";
require_once "../../helpers/functions.php";

// Habilitar errores (modo desarrollo)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 1) Obtener datos del formulario
    $username         = trim($_POST['username'] ?? '');
    $email            = trim($_POST['email'] ?? '');
    $nombre           = trim($_POST['nombre'] ?? '');
    $apellido         = trim($_POST['apellido'] ?? '');
    $password         = $_POST['password'] ?? '';
    $password_confirm = $_POST['password_confirm'] ?? '';
    $user_type        = $_POST['user_type'] ?? '1'; // Por defecto, Admin (0)

    // 2) Validar contraseñas
    if ($password !== $password_confirm) {
        redirect('register_in.php?error=1');
    }

    // 3) Verificar si el username o el email ya existen
    $sqlCheck = "SELECT COUNT(*) FROM users WHERE username = :username OR email = :email";
    $stmtCheck = $pdo->prepare($sqlCheck);
    $stmtCheck->execute([
        'username' => $username,
        'email'    => $email
    ]);
    $countExisting = $stmtCheck->fetchColumn();

    if ($countExisting > 0) {
        redirect('register_in.php?error=2');
    }

    // 4) Crear el hash de la contraseña
    $passwordHash = password_hash($password, PASSWORD_DEFAULT);

    // 5) Insertar en la base de datos, incluyendo user_type, level, nombre y apellido
    try {
        $sqlInsert = "INSERT INTO users (username, email, password, user_type, nombre, apellido, estado) 
              VALUES (:username, :email, :password, :user_type, :nombre, :apellido, :estado)";
$stmtInsert = $pdo->prepare($sqlInsert);
$stmtInsert->execute([
    'username'  => $username,
    'email'     => $email,
    'password'  => $passwordHash,
    'user_type' => $user_type,
    'nombre'    => $nombre,
    'apellido'  => $apellido,
    'estado'    => 0
]);


        // Redirigir a index.php con mensaje de éxito
        redirect('index.php?success=1');
    } catch (Exception $e) {
        // Muestra el error para depuración (quitar en producción)
        echo "Error: " . $e->getMessage();
        exit;
        // En producción podrías redirigir:
        // redirect('register_in.php?error=3');
    }
} else {
    redirect('register_in.php');
}
?>
