<?php
session_start();
require_once "../../config/db.php";
require_once "../../helpers/functions.php";
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Registro de Usuario</title>
  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="min-h-screen flex flex-col bg-white">
  <?php include "../assets/nav2.php"; ?>
  
  <main class="flex-grow pt-14">
    <div class="container mx-auto px-4 py-6">
      <div class="bg-white rounded-lg shadow px-4 py-5 sm:px-6 w-full max-w-md mx-auto">
        <h1 class="text-xl mb-4 font-bold">Crear Cuenta</h1>
        
        <!-- Mensajes de error (opcional) -->
        <?php if (isset($_GET['error'])): ?>
          <div class="text-red-500 mb-4">
            <?php 
              if ($_GET['error'] == 1) {
                  echo "Las contraseñas no coinciden.";
              } elseif ($_GET['error'] == 2) {
                  echo "Ese nombre de usuario o email ya está en uso.";
              } elseif ($_GET['error'] == 3) {
                  echo "Ocurrió un error al intentar crear la cuenta. Inténtalo de nuevo.";
              }
            ?>
          </div>
        <?php endif; ?>

        <!-- Mensaje de éxito -->
        <?php if (isset($_GET['success'])): ?>
          <div id="successMessage" class="bg-green-100 text-green-700 p-2 rounded mb-4 text-center">
            Usuario registrado exitosamente.
          </div>
          <script>
            setTimeout(function(){
              var successEl = document.getElementById("successMessage");
              if(successEl){
                successEl.style.display = "none";
              }
            }, 2000);
          </script>
        <?php endif; ?>
        
        <form action="register_process_in.php" method="POST" class="space-y-4">
          <!-- Nombre de Usuario -->
          <div>
            <label for="username" class="block mb-1 font-medium">Nombre de Usuario</label>
            <input type="text" name="username" id="username" class="w-full border border-gray-300 p-2 rounded" required>
          </div>
          <!-- Email -->
          <div>
            <label for="email" class="block mb-1 font-medium">Email</label>
            <input type="email" name="email" id="email" class="w-full border border-gray-300 p-2 rounded" required>
          </div>
          <!-- Nombre -->
          <div>
            <label for="nombre" class="block mb-1 font-medium">Nombre</label>
            <input type="text" name="nombre" id="nombre" class="w-full border border-gray-300 p-2 rounded" required>
          </div>
          <!-- Apellido -->
          <div>
            <label for="apellido" class="block mb-1 font-medium">Apellido</label>
            <input type="text" name="apellido" id="apellido" class="w-full border border-gray-300 p-2 rounded" required>
          </div>
          <!-- Contraseña -->
          <div>
            <label for="password" class="block mb-1 font-medium">Contraseña</label>
            <input type="password" name="password" id="password" class="w-full border border-gray-300 p-2 rounded" required>
          </div>
          <!-- Confirmar Contraseña -->
          <div>
            <label for="password_confirm" class="block mb-1 font-medium">Confirmar Contraseña</label>
            <input type="password" name="password_confirm" id="password_confirm" class="w-full border border-gray-300 p-2 rounded" required>
          </div>
          <!-- Tipo de Usuario -->
          <div>
            <label for="user_type" class="block mb-1 font-medium">Tipo de Usuario</label>
            <select name="user_type" id="user_type" class="w-full border border-gray-300 p-2 rounded" required>
            <option value="1">Admin</option>  
            <option value="0">SuperAdmin</option>
              
            </select>
          </div>
          <button type="submit" class="w-full bg-blue-600 text-white py-2 rounded hover:bg-blue-700">
            Registrar Usuario
          </button>
        </form>
        
        <p class="mt-4 text-gray-600">
          ¿Ya tienes una cuenta? 
          <a href="login.php" class="text-blue-600 hover:underline">Inicia sesión</a>
        </p>
      </div>
    </div>
  </main>
  
  <?php include "../assets/footer.php"; ?>
</body>
</html>
