<?php
session_start();

require_once '../../config/db.php';
require_once '../../helpers/functions.php';
$stmt = $pdo->query("SELECT * FROM users WHERE estado = 0 AND user_type != 15");
$users = $stmt->fetchAll();

?>
<!DOCTYPE html>
<html lang="es" class="h-full bg-white">
<head>
  <meta charset="UTF-8">
  <title>Listado de Usuarios</title>
  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
  
  <!-- DataTables CSS -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
  <!-- DataTables Buttons CSS (para CSV/Excel) -->
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
  
  <style>
    body {
      background-color: #fff;
      font-family: 'Inter', sans-serif;
    }
    .dataTables_wrapper,
    .dataTables_wrapper .dataTables_filter,
    .dataTables_wrapper .dataTables_length,
    .dataTables_wrapper .dataTables_info,
    .dataTables_wrapper .dataTables_paginate {
      font-size: 0.875rem;
      line-height: 1.25rem;
      color: #374151;
      font-family: inherit;
    }
    .dataTables_wrapper .dataTables_filter input {
      font-size: inherit;
      line-height: inherit;
      color: inherit;
      font-family: inherit;
      border: 1px solid #d2d6dc;
      border-radius: 0.375rem;
      padding: 0.5rem 0.75rem;
      outline: none;
    }
    .dataTables_wrapper .dataTables_paginate .paginate_button {
      font-size: inherit;
      line-height: inherit;
      color: inherit;
      font-family: inherit;
      background-color: #fff;
      border: 1px solid #d2d6dc;
      border-radius: 0.375rem;
      padding: 0.25rem 0.75rem;
      margin: 0 0.25rem;
      cursor: pointer;
    }
    .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
      background-color: #f3f4f6;
    }
    .dataTables_wrapper .dataTables_paginate .paginate_button.current {
      background-color: #3b82f6;
      color: #fff !important;
      border-color: #3b82f6;
    }
    .dataTables_length select {
      -webkit-appearance: menulist;
      -moz-appearance: menulist;
      appearance: auto;
      background: none !important;
      background-image: none !important;
      font-size: inherit !important;
      line-height: inherit !important;
      text-align: center;
      text-align-last: center;
      -moz-text-align-last: center;
      padding-right: 2rem;
      border: 1px solid #d2d6dc;
      border-radius: 0.375rem;
      padding: 0.5rem 0.75rem;
      outline: none;
    }
    .dataTables_length label select {
      margin-right: 0.5rem; 
    }
    .dataTables_wrapper .dataTables_info,
    .dataTables_wrapper .dataTables_paginate {
      display: flex !important;
      align-items: center !important;
      margin: 0 !important;
    }
    #usersTable {
      table-layout: fixed;
      width: 100%;
    }
    #usersTable th, 
    #usersTable td {
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
    }
  </style>
</head>
<body class="min-h-screen flex flex-col bg-white">
  <?php include "../assets/nav2.php"; ?>

  
        
  <main class="flex-grow pt-14">
  
  <!-- Contenedor para el mensaje de éxito -->
  <div class="container mx-auto px-4">
    <?php if (isset($_GET['success'])): 
      $mensaje = "Usuario registrado o editado exitosamente.";
      if ($_GET['success'] === 'delete') {
        $mensaje = "Usuario eliminado correctamente.";
      } elseif ($_GET['success'] === 'update') {
        $mensaje = "Usuario editado correctamente.";
      } elseif ($_GET['success'] === '1') {
        $mensaje = "Usuario registrado exitosamente.";
      }
    ?>
      <div id="successMessage" class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mt-4 text-center">
        <?= $mensaje ?>
      </div>
      <script>
        setTimeout(function(){
          var successEl = document.getElementById("successMessage");
          if(successEl){
            successEl.style.display = "none";
          }
        }, 2000);
      </script>
    <?php endif; ?>
  </div>
  
  
    <div class="container mx-auto px-4 py-6">
      <!-- Card principal -->
      <div class="bg-white rounded-lg shadow px-4 py-5 sm:px-6">
        <!-- Cabecera: título y botón -->
        <div class="sm:flex sm:items-center sm:justify-between">
          <div>
            <h1 class="text-lg leading-6 font-medium text-gray-900">Listado de Usuarios</h1>
          </div>
          <div class="mt-4 sm:mt-0">
            <a href="register_in.php" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700">
              Agregar Nuevo Usuario
            </a>
          </div>
        </div>
        <!-- Tabla con DataTables -->
        <div class="mt-6 overflow-x-auto">
          <table id="usersTable" class="table-auto w-full text-sm leading-tight">
            <thead>
              <tr>
                <th class="px-2 py-2">Username</th>
                <th class="px-2 py-2">Tipo de Usuario</th>
                <th class="px-2 py-2">Nombre</th>
                <th class="px-2 py-2">Apellido</th>
                <th class="px-2 py-2">Email</th>
                <th class="px-2 py-2 noExport">Acciones</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($users as $user): ?>
                <tr class="hover:bg-gray-50">
                  <td class="px-2 py-2"><?= htmlspecialchars($user['username']) ?></td>
                  <td class="px-2 py-2">
                    <?php 
                      if ($user['user_type'] == 0) {
                        echo "Super Administrador";
                      } else {
                        echo "Administrador";
                      }
                    ?>
                  </td>
                  <td class="px-2 py-2"><?= htmlspecialchars($user['nombre'] ?? '') ?></td>
                  <td class="px-2 py-2"><?= htmlspecialchars($user['apellido'] ?? '') ?></td>
                  <td class="px-2 py-2"><?= htmlspecialchars($user['email']) ?></td>
                  <td class="px-2 py-2 noExport">
                    <a href="edit.php?id=<?= $user['id'] ?>" class="text-blue-600 hover:underline">Editar</a> |
                    <a href="delete.php?id=<?= $user['id'] ?>" class="text-red-600 hover:underline" onclick="return confirm('¿Está seguro de eliminar este usuario?');">Eliminar</a>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div><!-- /.overflow-x-auto -->
      </div><!-- /.bg-white rounded-lg shadow -->
    </div><!-- /.container -->
  </main>
  

  <?php include "../assets/footer.php"; ?>
  
  <!-- jQuery -->
  <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
  <!-- DataTables JS -->
  <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
  <!-- DataTables Buttons JS (para CSV/Excel) -->
  <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
  <!-- JSZip para Excel -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
  <script>
    $(document).ready(function() {
      var table = $('#usersTable').DataTable({
        dom: "<'flex items-center justify-between mb-4'l f>t<'flex items-center justify-between mt-4'i p>",
        buttons: [
          {
            extend: 'csvHtml5',
            text: 'Exportar CSV',
            exportOptions: { columns: ':not(.noExport)' }
          },
          {
            extend: 'excelHtml5',
            text: 'Exportar Excel',
            exportOptions: { columns: ':not(.noExport)' }
          }
        ],
        language: {
          "decimal": "",
          "emptyTable": "No hay información",
          "info": "Mostrando _START_ a _END_ de _TOTAL_ usuarios",
          "infoEmpty": "Mostrando 0 a 0 de 0 usuarios",
          "infoFiltered": "(Filtrado de _MAX_ usuarios en total)",
          "lengthMenu": "Mostrar _MENU_ usuarios",
          "loadingRecords": "Cargando...",
          "processing": "Procesando...",
          "search": "Buscar:",
          "zeroRecords": "No se encontraron usuarios",
          "paginate": {
            "first": "Primero",
            "last": "Último",
            "next": "Siguiente",
            "previous": "Anterior"
          }
        }
      });
    });
  </script>
</body>
</html>
