<?php
session_start();
require_once "../../config/db.php";
require_once "../../helpers/functions.php";

// Obtener el id del usuario desde GET
$id = $_GET['id'] ?? null;
if (!$id) {
    redirect('index.php');
}

// Consultar el registro del usuario
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = :id LIMIT 1");
$stmt->execute(['id' => $id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    redirect('index.php');
}
?>
<!DOCTYPE html>
<html lang="es" class="h-full bg-white">
<head>
  <meta charset="UTF-8">
  <title>Editar Usuario</title>
  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body {
      background-color: #fff;
      font-family: 'Inter', sans-serif;
    }
  </style>
</head>
<body class="min-h-screen flex flex-col bg-white">
  <?php include "../assets/nav2.php"; ?>
  <main class="flex-grow pt-14">
    <div class="container mx-auto px-4 py-6">
      <!-- Card principal -->
      <div class="bg-white rounded-lg shadow px-4 py-5 sm:px-6 w-full max-w-md mx-auto">
        <h1 class="text-xl mb-4 font-bold">Editar Usuario</h1>
        <form action="update.php" method="POST" class="space-y-4">
          <!-- Campo oculto para el id -->
          <input type="hidden" name="id" value="<?= htmlspecialchars($user['id']) ?>">
          
          <!-- Nombre de Usuario -->
          <div>
            <label for="username" class="block mb-1 font-medium">Nombre de Usuario</label>
            <input type="text" name="username" id="username" value="<?= htmlspecialchars($user['username']) ?>" class="w-full border border-gray-300 p-2 rounded" required>
          </div>
          
          <!-- Email -->
          <div>
            <label for="email" class="block mb-1 font-medium">Email</label>
            <input type="email" name="email" id="email" value="<?= htmlspecialchars($user['email']) ?>" class="w-full border border-gray-300 p-2 rounded" required>
          </div>
          
          <!-- Nombre -->
          <div>
            <label for="nombre" class="block mb-1 font-medium">Nombre</label>
            <input type="text" name="nombre" id="nombre" value="<?= htmlspecialchars($user['nombre']) ?>" class="w-full border border-gray-300 p-2 rounded" required>
          </div>
          
          <!-- Apellido -->
          <div>
            <label for="apellido" class="block mb-1 font-medium">Apellido</label>
            <input type="text" name="apellido" id="apellido" value="<?= htmlspecialchars($user['apellido']) ?>" class="w-full border border-gray-300 p-2 rounded" required>
          </div>
          
          <!-- Contraseña (dejar en blanco si no se desea cambiar) -->
          <div>
            <label for="password" class="block mb-1 font-medium">Nueva Contraseña</label>
            <input type="password" name="password" id="password" placeholder="Dejar en blanco para no cambiar" class="w-full border border-gray-300 p-2 rounded">
          </div>
          
          <!-- Confirmar Contraseña (solo si se ingresa una nueva) -->
          <div>
            <label for="password_confirm" class="block mb-1 font-medium">Confirmar Nueva Contraseña</label>
            <input type="password" name="password_confirm" id="password_confirm" placeholder="Dejar en blanco para no cambiar" class="w-full border border-gray-300 p-2 rounded">
          </div>
          
          <!-- Tipo de Usuario -->
          <div>
            <label for="user_type" class="block mb-1 font-medium">Tipo de Usuario</label>
            <select name="user_type" id="user_type" class="w-full border border-gray-300 p-2 rounded" required>
              <option value="1" <?= ($user['user_type'] == 1) ? 'selected' : '' ?>>SuperAdmin</option>
              <option value="0" <?= ($user['user_type'] == 0) ? 'selected' : '' ?>>Admin</option>
            </select>
          </div>
          
          <!-- Botón de Envío -->
          <button type="submit" class="w-full bg-blue-600 text-white py-2 rounded hover:bg-blue-700">
            Actualizar Usuario
          </button>
        </form>
      </div>
    </div>
  </main>
  <?php include "../assets/footer.php"; ?>
</body>
</html>
