<?php
session_start();
require_once "../../config/db.php";
require_once "../../helpers/functions.php";

// Habilitar errores (solo en desarrollo)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Obtener el id del registro
$id = $_GET['id'] ?? null;
if (!$id) {
    // Si no se proporciona un ID, redirigir a index
    redirect('index.php');
    exit;
}

try {
    // Actualizar la columna estado a 1 (soft delete)
    $sql = "UPDATE users SET estado = 1 WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['id' => $id]);

    // Redirigir con mensaje de éxito
    redirect('index.php?success=delete');
} catch (Exception $e) {
    // En caso de error, podrías mostrar el mensaje o redirigir con un mensaje de error
    echo "Error: " . $e->getMessage();
    exit;
}
