<?php
/**
 * public/trips/update_trip_status.php
 * Actualiza el estado de facturación de un viaje (Facturado / No Facturado)
 * y registra el cambio en logs.
 */
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido']);
    exit;
}

$trip_id = $_POST['trip_id'] ?? null;
$nuevo_estado = $_POST['estado_facturacion'] ?? null;

if (!$trip_id || !$nuevo_estado) {
    http_response_code(400);
    echo json_encode(['error' => 'Datos incompletos']);
    exit;
}

try {
    // 1. Actualizar estado en tabla trips
    $sql = "UPDATE trips
            SET estado_facturacion = :estado_facturacion,
                updated_at = NOW()
            WHERE id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'estado_facturacion' => $nuevo_estado,
        'id' => $trip_id
    ]);

    // 2. Registrar log
    $logSql = "INSERT INTO logs (grupo, tipo, cambios, id_modif, user, fecha)
               VALUES ('viaje', 2, :cambios, :id_modif, :user, NOW())";
    $pdo->prepare($logSql)->execute([
        'cambios'  => json_encode(['estado_facturacion' => $nuevo_estado], JSON_UNESCAPED_UNICODE),
        'id_modif' => $trip_id,
        'user'     => $_SESSION['user_id'] ?? 0
    ]);

    echo json_encode(['success' => true, 'estado' => $nuevo_estado]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Error al actualizar estado']);
}