<?php
/**
 * public/trips/trip.php
 * Vista "Ver Viaje" en SOLO LECTURA, con encabezado unificado (nav2)
 */
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

/* Entrada */
$id = $_GET['id'] ?? null;
if (!$id) {
    header('Location: index.php');
    exit;
}

/* Consulta */
$stmt = $pdo->prepare("
    SELECT 
      t.*,
      d.nombre   AS driver_nombre,
      d.apellido AS driver_apellido,
      p1.nombre  AS origen_nombre,
      p2.nombre  AS destino_nombre
    FROM trips t
    LEFT JOIN drivers d   ON t.driver_id      = d.id
    LEFT JOIN places  p1  ON t.origin_id      = p1.id
    LEFT JOIN places  p2  ON t.destination_id = p2.id
    WHERE t.id = :id
    LIMIT 1
");
$stmt->execute(['id' => $id]);
$trip = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$trip) {
    $_SESSION['error'] = "Viaje no encontrado.";
    header('Location: index.php');
    exit;
}

/* Helpers */
function renderArchivo($filename) {
    if (!$filename) {
        return "<div class='text-muted small fst-italic border rounded p-3 text-center'>No cargado</div>";
    }
    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
    $url = "../uploads/" . htmlspecialchars($filename, ENT_QUOTES, 'UTF-8');

    if (in_array($ext, ['jpg','jpeg','png','gif','webp'])) {
        return "<a href='{$url}' target='_blank' rel='noopener'>
                  <img src='{$url}' alt='Archivo'
                       class='img-thumbnail' style='width:100px;height:100px;object-fit:cover'>
                </a>";
    } elseif ($ext === 'pdf') {
        return "<a href='{$url}' target='_blank' rel='noopener' class='btn btn-sm btn-danger'>📄 Ver PDF</a>";
    } else {
        return "<a href='{$url}' target='_blank' rel='noopener' class='text-primary small'>Descargar archivo</a>";
    }
}
function h($v, $fallback = '—') {
    if (!isset($v) || $v === '' || $v === null) return $fallback;
    return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
}
function n2($v) { $v = (float)($v ?? 0); return number_format($v, 2, ',', '.'); }
function n0($v) { $v = (float)($v ?? 0); return number_format($v, 0, ',', '.'); }

/* Vars */
$choferNombre = trim(($trip['driver_nombre'] ?? '') . ' ' . ($trip['driver_apellido'] ?? ''));
$km           = $trip['km_recorridos'] ?? null;
$toneladas    = $trip['toneladas']     ?? null;
$ctg_val      = $trip['CTG'] ?? ($trip['ctg'] ?? null);

$cuit_fact         = $trip['cuit_facturacion']       ?? ($trip['cuit'] ?? null);
$cliente_fact      = $trip['cliente_fact']           ?? null;
$chofer_fact       = $trip['chofer_fact']            ?? $choferNombre;
$tarifa_fact       = $trip['tarifa_fact']            ?? $trip['tarifa_real'] ?? null;
$email_fact        = $trip['email_facturacion']      ?? null;
$telefono_fact     = $trip['telefono_facturacion']   ?? null;
$medio_pago_fact   = $trip['medio_pago_facturacion'] ?? null;
$estado_fact       = $trip['estado_facturacion']     ?? null;
$linea_factura     = $trip['linea_factura']          ?? null;

/* Buscar cliente */
$cliente_nombre = null;
try {
    if (!empty($trip['customer_id'])) {
        $cst = $pdo->prepare("SELECT razon_social, cuit, email, telefono, medio_pago FROM customers WHERE id = :id LIMIT 1");
        $cst->execute(['id' => $trip['customer_id']]);
        if ($row = $cst->fetch(PDO::FETCH_ASSOC)) {
            $cliente_nombre = $row['razon_social'] ?? null;
            if (!$cuit_fact)       $cuit_fact       = $row['cuit'] ?? $cuit_fact;
            if (!$email_fact)      $email_fact      = $row['email'] ?? $email_fact;
            if (!$telefono_fact)   $telefono_fact   = $row['telefono'] ?? $telefono_fact;
            if (!$medio_pago_fact) $medio_pago_fact = $row['medio_pago'] ?? $medio_pago_fact;
        }
    }
} catch (\Throwable $e) {}
?>
<!DOCTYPE html>
<html lang="es" class="h-full bg-white">
<head>
  <meta charset="UTF-8">
  <title>Ver Viaje #<?= h($trip['id']) ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Bootstrap Icons -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

  <style>
    /* === Estilos globales del header unificado (nav2) === */
    :root { --nav-bg:#1f2b35; }
    .main-navbar{
      background:var(--nav-bg);
      border-bottom:1px solid rgba(0,0,0,.15);
      position:fixed; top:0; left:0; width:100%;
      z-index:1080; height:64px;
    }
    .content-wrap { margin-top: 82px; }

    /* Fix cuando Tailwind está activo y colapsa el menú */
    .navbar .collapse{ visibility: visible !important; }

    /* Estilos propios de esta vista */
    .block-title { font-weight:600; font-size:.95rem; color:#374151; margin-bottom:.4rem; }
    .box { padding:0.6rem; border:1px solid #e5e7eb; border-radius:6px; background:#fff; }

    /* >>> Nueva disposición: etiqueta arriba, dato abajo (como en editar) <<< */
    .kv{
      display:flex;
      flex-direction:column;
      align-items:flex-start;
      gap:2px;
      margin-bottom:.4rem;
    }
    .kv label{
      color:#6b7280;
      font-size:.8rem;
      line-height:1.1;
    }
    .kv div{
      font-weight:600;
      font-size:.9rem;
      line-height:1.2;
    }

    .mono { font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Courier New", monospace; }
    .btn:hover { filter: brightness(0.95); transition: filter .15s, transform .15s; transform: translateY(-1px); }

    /* === FIX GENERAL PARA ESTA VISTA EN CELULAR === */
    html, body{
      max-width:100%;
      overflow-x:hidden;
    }

    /* Todo el contenido de Ver Viaje está bajo .trip-view-main */
    .trip-view-main .container,
    .trip-view-main .container-fluid{
      max-width: 1100px;
    }

    @media (max-width: 768px){
      /* El contenedor ocupa todo el ancho del móvil */
      .trip-view-main .container,
      .trip-view-main .container-fluid{
        max-width: 100% !important;
        width: 100% !important;
        padding-left: 12px !important;
        padding-right: 12px !important;
        margin-left: 0 !important;
        margin-right: 0 !important;
      }

      /* Forzar los 3 bloques en columna */
      .trip-columns{
        display:flex !important;
        flex-direction:column !important;
        gap: 12px !important;
      }
      .trip-columns > [class*="col-"]{
        flex: 0 0 100% !important;
        max-width: 100% !important;
        width: 100% !important;
      }

      .box{
        margin-bottom: 4px;
      }
    }
  </style>

  <!-- BLOQUES DE ESTILO PARA IMPRESIÓN (tal como tenías) -->
    <!-- Estilos de IMPRESIÓN – Formato horizontal (A4 landscape) -->
  <style>
    @media print {
      @page {
        size: A4 landscape;
        margin: 8mm;
      }

      html, body {
        background: #fff !important;
        color: #111 !important;
        font-size: 11px !important;
        line-height: 1.3 !important;
        -webkit-print-color-adjust: exact !important;
        print-color-adjust: exact !important;
      }

      /* Ocultar elementos que no deben imprimirse */
      .main-navbar,
      .navbar,
      .no-print,
      .btn,
      .dt-buttons,
      .dataTables_length,
      .dataTables_filter,
      .dataTables_info,
      .dataTables_paginate,
      footer {
        display: none !important;
      }

      /* Contenedor ocupa todo el ancho */
      .content-wrap {
        margin: 0 !important;
        padding: 0 !important;
      }
      .container, .container-fluid {
        max-width: 100% !important;
        width: 100% !important;
        padding: 0 6mm !important;
      }

      /* Tres columnas principales */
      .trip-columns {
        display: flex !important;
        flex-direction: row !important;
        justify-content: space-between !important;
        gap: 6px !important;
      }
      .trip-columns > [class*="col-"] {
        flex: 1 1 0 !important;
        max-width: 33.333% !important;
        padding: 0 !important;
      }

      /* Cajas de información */
      .box {
        padding: 6px 8px !important;
        border: 1px solid #ccc !important;
        border-radius: 4px !important;
        background: #fff !important;
        box-shadow: none !important;
        page-break-inside: avoid !important;
        break-inside: avoid !important;
      }

      /* Título de bloque */
      .block-title {
        font-size: 12px !important;
        font-weight: bold !important;
        color: #000 !important;
        margin-bottom: 4px !important;
        border-bottom: 1px solid #ccc !important;
        padding-bottom: 2px !important;
      }

      /* Pares etiqueta / valor en una línea compacta */
      .kv {
        display: grid !important;
        grid-template-columns: 150px 1fr !important;
        gap: 0 6px !important;
        align-items: baseline !important;
        margin-bottom: 2px !important;
      }
      .kv label {
        font-size: 10px !important;
        color: #555 !important;
        text-align: right !important;
      }
      .kv div {
        font-size: 11px !important;
        font-weight: 600 !important;
        color: #000 !important;
      }

      /* Comentarios y resumen */
      .mt-6, .my-6, .mb-6 { margin: 6px 0 !important; }
      .px-6, .py-6, .p-6  { padding: 6px !important; }
      .text-sm { font-size: 10px !important; }

      /* Archivos compactos al final */
      .section-archivos {
        display: block !important;
        page-break-inside: avoid !important;
      }
      .section-archivos .row.g-3 {
        display: flex !important;
        flex-wrap: nowrap !important;
        gap: 4px !important;
      }
      .section-archivos img.img-thumbnail {
        width: 32px !important;
        height: 32px !important;
        object-fit: cover !important;
        border: 1px solid #ccc !important;
        padding: 0 !important;
      }
      .section-archivos p.small {
        font-size: 9px !important;
        margin-bottom: 1px !important;
      }

      /* Quitar sombras y márgenes innecesarios */
      * {
        box-shadow: none !important;
      }
    }
  </style>


</head>

<body class="h-full bg-white flex flex-col">
  <?php include "../assets/nav2.php"; ?>

  <main class="content-wrap trip-view-main">
    <div class="container mx-auto px-4 py-6">
      <div class="bg-white rounded-lg shadow overflow-hidden">

        <!-- Header -->
        <div class="px-6 py-5 d-flex justify-content-between align-items-center">
          <div>
            <h1 class="text-lg font-medium text-gray-900 mb-0">Detalle del Viaje</h1>
            <p class="text-sm text-gray-500 mb-0">Número de Viaje: <strong><?= h($trip['id']) ?></strong></p>
          </div>
          <div class="no-print btn-group gap-2">
            <a href="edit.php?id=<?= urlencode($trip['id']) ?>" 
               class="btn btn-primary btn-sm text-white d-flex align-items-center gap-1">
               <i class="bi bi-pencil"></i> Editar
            </a>
            <a href="delete.php?id=<?= urlencode($trip['id']) ?>" 
               onclick="return confirm('¿Eliminar este viaje?');" 
               class="btn btn-danger btn-sm text-white d-flex align-items-center gap-1">
               <i class="bi bi-trash"></i> Eliminar
            </a>
            <button type="button" onclick="window.print()" 
                    class="btn btn-warning btn-sm text-white d-flex align-items-center gap-1"
                    style="background-color:#f68b1e;border:none;">
              <i class="bi bi-printer"></i> Imprimir
            </button>
            <a href="index.php" class="btn btn-dark btn-sm text-white d-flex align-items-center gap-1">
               <i class="bi bi-arrow-left"></i> Volver
            </a>
          </div>
        </div>

        <div class="border-top px-6 py-6">
          <!-- === BLOQUES SUPERIORES === -->
          <div class="row g-4 trip-columns">
            <!-- Columna 1 -->
            <div class="col-12 col-md-4">
              <div class="box">
                <div class="block-title">Datos de alta del viaje</div>
                <div class="kv">
                  <label>Cliente</label>
                  <div><?= h($cliente_nombre ?? $trip['cliente'] ?? $trip['customer_id'] ?? '—') ?></div>
                </div>
                <div class="kv">
                  <label>Chofer</label>
                  <div><?= h($choferNombre ?: '—') ?></div>
                </div>
                <div class="kv">
                  <label>Origen</label>
                  <div><?= h($trip['origen_nombre'] ?? '—') ?></div>
                </div>
                <div class="kv">
                  <label>Destino</label>
                  <div><?= h($trip['destino_nombre'] ?? '—') ?></div>
                </div>
                <div class="kv">
                  <label>Mercadería</label>
                  <div><?= h($trip['mercaderia'] ?? '—') ?></div>
                </div>
                <div class="kv">
                  <label>Toneladas de Carga</label>
                  <div class="mono">
                    <?= isset($trip['toneladas_carga']) && $trip['toneladas_carga'] !== '' ? n2($trip['toneladas_carga']) : '—' ?>
                  </div>
                </div>
                <div class="kv">
                  <label>Fecha Origen</label>
                  <div><?= h($trip['fecha_origen'] ?? '—') ?></div>
                </div>
                <div class="kv">
                  <label>Tarifa Real</label>
                  <div class="mono">$ <?= n2($trip['tarifa_real'] ?? 0) ?></div>
                </div>
                <div class="kv">
                  <label>Kilómetros</label>
                  <div class="mono"><?= n0($km) ?></div>
                </div>
                <div class="kv">
                  <label>CTG / N° de RM</label>
                  <div class="mono"><?= h($ctg_val ?? '—') ?></div>
                </div>
                <div class="kv">
                  <label>Transporte</label>
                  <div><?= h($trip['tipo_transporte'] ?? '—') ?></div>
                </div>
              </div>
            </div>

            <!-- Columna 2 -->
            <div class="col-12 col-md-4">
              <div class="box">
                <div class="block-title">Datos de final del viaje</div>
                <div class="kv">
                  <label>Fecha Destino</label>
                  <div><?= h($trip['fecha_destino'] ?? '—') ?></div>
                </div>
                <div class="kv">
                  <label>Tarifa Rendida</label>
                  <div class="mono">$ <?= n2($trip['tarifa_rendida'] ?? 0) ?></div>
                </div>
                <div class="kv">
                  <label>Toneladas de descarga</label>
                  <div class="mono"><?= n2($toneladas) ?></div>
                </div>
                <div class="kv">
                  <label>Estado del Viaje</label>
                  <div><?= h($trip['estado_viaje'] ?? '—') ?></div>
                </div>
              </div>
            </div>

            <!-- Columna 3 -->
            <div class="col-12 col-md-4">
              <div class="box">
                <div class="block-title">Datos para facturación</div>
                <div class="kv">
                  <label>CUIT</label>
                  <div class="mono"><?= h($cuit_fact ?? '—') ?></div>
                </div>
                <div class="kv">
                  <label>Cliente</label>
                  <div><?= h($cliente_fact ?? $cliente_nombre ?? '—') ?></div>
                </div>
                <div class="kv">
                  <label>Chofer</label>
                  <div><?= h($chofer_fact ?? $choferNombre ?? '—') ?></div>
                </div>
                <div class="kv">
                  <label>Tarifa Real (facturación)</label>
                  <div class="mono">$ <?= n2($tarifa_fact ?? 0) ?></div>
                </div>
                <div class="kv">
                  <label>Email principal</label>
                  <div><?= h($email_fact ?? '—') ?></div>
                </div>
                <div class="kv">
                  <label>Teléfono</label>
                  <div><?= h($telefono_fact ?? '—') ?></div>
                </div>
                <div class="kv">
                  <label>Medio de pago habitual</label>
                  <div><?= h($medio_pago_fact ?? '—') ?></div>
                </div>
                <div class="kv">
                  <label>Facturación</label>
                  <div><?= h($estado_fact ?? '—') ?></div>
                </div>
                <div class="kv">
                  <label>N° de Factura</label>
                  <div class="mono"><?= h($trip['numero_factura'] ?? '') ?></div>
                </div>
                <div class="kv">
                  <label>Pago</label>
                  <div><?= h($trip['estado_pago'] ?? '—') ?></div>
                </div>
              </div>
            </div>
          </div>

          <!-- Comentario -->
          <div class="mt-6">
            <label class="block text-sm text-gray-600 mb-2">Comentario</label>
            <div class="border rounded p-3 bg-white text-sm">
              <?= ($trip['comentario'] ?? '') !== '' ? nl2br(h($trip['comentario'])) : "<span class='text-muted'>—</span>" ?>
            </div>
          </div>

          <!-- Resumen -->
          <div class="mt-4">
            <label class="block text-sm text-gray-600 mb-2">Resumen del viaje</label>
            <div class="min-h-[48px] border rounded p-2 bg-white text-sm">
              <?= h($linea_factura ?? '—') ?>
            </div>
          </div>

          <!-- Archivos -->
          <div class="mt-6 section-archivos">
            <div class="block-title mb-2">Archivos</div>
            <div class="row g-3">
              <?php for ($i=1; $i<=5; $i++): 
                $campo = $i===1 ? 'foto' : 'foto'.$i; ?>
                <div class="col-12 col-md-6 col-lg-4">
                  <p class="small text-muted mb-1">Archivo <?= $i ?></p>
                  <?= renderArchivo($trip[$campo] ?? '') ?>
                </div>
              <?php endfor; ?>
            </div>
          </div>

        </div>
      </div>
    </div>
  </main>

  <?php include "../assets/footer.php"; ?>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>