<?php
require_once '../../config/db.php';  // Ajusta la ruta a db.php según tu estructura

// El término que el usuario está tecleando en el buscador
$term = $_GET['term'] ?? '';

// Consulta SQL: busca por "nombre" en la tabla "places"
$sql = "
    SELECT 
        id, 
        nombre AS text 
    FROM places 
    WHERE nombre LIKE :term 
    AND estado = 0
    ORDER BY nombre ASC 
    LIMIT 20
";
$stmt = $pdo->prepare($sql);
$stmt->execute(['term' => '%' . $term . '%']);
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Devolvemos los resultados como JSON para que Select2 los interprete
echo json_encode($results);
