<?php
/**
 * public/trips/search_drivers.php
 * Devuelve choferes ACTIVOS (estado = 1) para Select2.
 * Busca por nombre, apellido, nombre completo o teléfono.
 */
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

/* --- No caché para evitar que el navegador reuse resultados viejos --- */
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

$term = trim($_GET['term'] ?? '');
$q = $term === '' ? '' : "%{$term}%";

/* 
   ✅ COALESCE(estado, 1) = 1
   - Si estado es NULL lo tratamos como 1 (inactivo) para que NO pase.
   - Solo pasa estado = 1 (activo).
*/
$sql = "
  SELECT id, nombre, apellido, telefono
  FROM drivers
  WHERE COALESCE(estado, 1) = 1
    AND (
      :q = '' 
      OR nombre LIKE :q 
      OR apellido LIKE :q
      OR CONCAT(nombre, ' ', apellido) LIKE :q
      OR telefono LIKE :q
    )
  ORDER BY nombre ASC, apellido ASC
  LIMIT 50
";
$stmt = $pdo->prepare($sql);
$stmt->execute(['q' => $q]);

$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* Formato Select2 */
$out = [];
foreach ($rows as $r) {
  $nombre = trim(($r['nombre'] ?? '') . ' ' . ($r['apellido'] ?? ''));
  $text = $nombre;
  if (!empty($r['telefono'])) $text .= " — " . $r['telefono'];
  $out[] = ['id' => (int)$r['id'], 'text' => $text];
}

echo json_encode($out);