<?php
session_start();
require_once "../../config/db.php";
require_once "../../helpers/functions.php";
check_auth();
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Listado de Viajes</title>

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- DataTables CSS + Buttons -->
  <link href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.bootstrap5.min.css" rel="stylesheet">
  <!-- Bootstrap Icons -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

  <style>
/* --- Visibilidad y solapamientos (sin romper mobile) --- */
.table-responsive {
  overflow-x: auto !important;    /* scroll horizontal SOLO dentro de la tabla en mobile */
  overflow-y: visible !important; /* los dropdowns siguen saliendo por encima */
}
table.dataTable { width: 100% !important; }  /* que la tabla no fuerce ancho mayor */
table.dataTable tbody tr { position: relative !important; z-index: 1; }

/* Evita “arrastre lateral” del sitio en móvil */
html, body { max-width: 100%; overflow-x: hidden; }

/* ===== Encabezado unificado ===== */
.content-wrap { margin-top: 82px; padding-bottom: 40px; }
.navbar .collapse { visibility: visible !important; }

body {
  background-color: #f6f7f8;
  font-family: "Segoe UI", Arial, sans-serif;
  font-size: 14px;
  color: #222;
  margin: 0;
  padding: 0;
}

.page-card {
  border-radius: 8px;
  border: 1px solid #e6e9ec;
  background: #fff;
}

/* --- Estandarización visual de columnas --- */
#tripsTable th, #tripsTable td {
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
  vertical-align: middle;
  text-align: left;
  padding: 0.45rem 0.5rem !important;
  max-width: 140px;
  font-size: 13.5px;
  line-height: 1.3;
}

/* Mapeo de columnas (14 columnas totales, contando ocultas)
   1: ID
   2: Chofer
   3: Origen
   4: Destino
   5: Fecha Origen
   6: Fecha Destino (oculta)
   7: Km (oculto)
   8: Tipo
   9: Cliente
   10: Estado Viaje
   11: Facturación
   12: Nº Factura (oculta)
   13: Pago
   14: Acciones
*/

#tripsTable th:nth-child(1),  #tripsTable td:nth-child(1)  { max-width: 45px;  }  /* ID */
#tripsTable th:nth-child(2),  #tripsTable td:nth-child(2)  { max-width: 90px;  }  /* Chofer */
#tripsTable th:nth-child(3),  #tripsTable td:nth-child(3)  { max-width: 100px; }  /* Origen */
#tripsTable th:nth-child(4),  #tripsTable td:nth-child(4)  { max-width: 100px; }  /* Destino */
#tripsTable th:nth-child(5),  #tripsTable td:nth-child(5)  { max-width: 100px; }  /* Fecha Origen */
/* 6 = Fecha Destino (oculta) */
/* 7 = Km (oculto) */
#tripsTable th:nth-child(8),  #tripsTable td:nth-child(8)  { max-width: 60px;  }  /* Tipo */
#tripsTable th:nth-child(9),  #tripsTable td:nth-child(9)  { max-width: 120px; }  /* Cliente */
#tripsTable th:nth-child(10), #tripsTable td:nth-child(10) { max-width: 100px; }  /* Estado */
#tripsTable th:nth-child(11), #tripsTable td:nth-child(11) { max-width: 120px; }  /* Facturación */
/* 12 = Nº Factura (oculta) */
#tripsTable th:nth-child(13), #tripsTable td:nth-child(13) { max-width: 100px; }  /* Pago */
#tripsTable th:nth-child(14), #tripsTable td:nth-child(14) { max-width: 110px; }  /* Acciones */

/* La tabla un poco más contenida en desktop */
.table-responsive {
  overflow-x: auto !important;
  max-width: 90%;
  margin: 0 auto;
}

/* Texto de estado (sin badges) */
.estado-ok    { color: #198754 !important; font-weight: 600; }
.estado-pend  { color: #0d6efd !important; font-weight: 600; }

/* Botón exportar Excel */
.btn-warning.text-white {
  background-color: #f68b1e !important;
  border: none !important;
  color: #fff !important;
}
.btn-warning.text-white:hover {
  background-color: #e27913 !important;
  color: #fff !important;
}

/* Botones de acciones (íconos) */
.btn-icon {
  width: 32px;
  height: 32px;
  display: inline-flex;
  align-items: center;
  justify-content: center;
  border-radius: .5rem;
  border: none;
}
.btn-icon.orange { background: #f68b1e; color: #fff; }
.btn-icon.blue   { background: #0d6efd; color: #fff; }
.btn-icon.red    { background: #dc3545; color: #fff; }
.btn-icon:hover  { filter: brightness(0.92); color: #fff; }

/* PAGINACIÓN igual a Clientes/Lugares/Choferes */
.dataTables_wrapper .dataTables_paginate ul.pagination .page-item .page-link {
  background-color: #000 !important;
  color: #fff !important;
  border: 1px solid #000 !important;
  border-radius: 4px !important;
  margin: 0 2px !important;
  padding: 6px 12px !important;
  line-height: 1.2 !important;
}
.dataTables_wrapper .dataTables_paginate ul.pagination .page-item .page-link:hover {
  filter: brightness(1.25);
  color: #fff !important;
  text-decoration: none !important;
}
.dataTables_wrapper .dataTables_paginate ul.pagination .page-item.active .page-link {
  background-color: #f68b1e !important;
  border-color: #f68b1e !important;
  color: #fff !important;
}
.dataTables_wrapper .dataTables_paginate ul.pagination .page-item.disabled .page-link {
  background-color: #000 !important;
  color: #bbb !important;
  opacity: 0.6;
  cursor: not-allowed;
}

/* Ajuste para móviles */
@media (max-width: 768px) {
  .btn-icon {
    width: 26px;
    height: 26px;
    font-size: 12px;
    border-radius: .4rem;
    padding: 0;
  }
  #tripsTable th:nth-child(14),
  #tripsTable td:nth-child(14) {
    max-width: 85px;
  }
}
</style>
</head>

<body>
<?php include "../assets/nav2.php"; ?>

<div class="content-wrap container-fluid">
  <div class="page-card card">
    <div class="card-body">
      <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap gap-2">
        <h5 class="mb-0 text-primary fw-bold">Listado de Viajes</h5>
        <a href="create.php" class="btn btn-primary">Crear Nuevo Viaje</a>
      </div>

      <!-- Filtros -->
      <div class="border rounded p-3 mb-3 bg-white">
        <div class="row g-2 align-items-center mb-2">
          <div class="col-md-2"><input id="filter_driver" class="form-control" placeholder="Buscar por Chofer"></div>
          <div class="col-md-2"><input id="filter_origin" class="form-control" placeholder="Buscar por Origen"></div>
          <div class="col-md-2"><input id="filter_destination" class="form-control" placeholder="Buscar por Destino"></div>
          <div class="col-md-2"><input type="date" id="filter_start_date" class="form-control" placeholder="Desde"></div>
          <div class="col-md-2"><input type="date" id="filter_end_date" class="form-control" placeholder="Hasta"></div>
          <div class="col-md-2 text-end">
            <button id="clear_filters" class="btn btn-dark w-100">Limpiar filtros</button>
          </div>
        </div>
      </div>

      <!-- Tabla -->
      <div class="table-responsive">
        <table id="tripsTable" class="table table-striped table-hover align-middle" style="width:100%; position:relative;">
          <thead class="table-light">
            <tr>
              <th>ID</th>
              <th>Chofer</th>
              <th>Origen</th>
              <th>Destino</th>
              <th>Fecha Origen</th>
              <th class="d-none">Fecha Destino (oculta)</th> <!-- 6 -->
              <th class="d-none">Km (oculto)</th>             <!-- 7: km_recorridos -->
              <th>Tipo</th>                                   <!-- 8 -->
              <th>Cliente</th>                                <!-- 9 -->
              <th>Estado Viaje</th>                           <!-- 10 -->
              <th>Facturación</th>                            <!-- 11 -->
              <th class="d-none">N° Factura (oculta)</th>     <!-- 12 -->
              <th>Pago</th>                                   <!-- 13 -->
              <th>Acciones</th>                               <!-- 14 -->
            </tr>
          </thead>
          <tbody>
          <?php
          $sql = "SELECT
                    t.*,
                    d.nombre AS driver_nombre,
                    d.apellido AS driver_apellido,
                    p1.nombre AS origen_nombre,
                    p2.nombre AS destino_nombre,
                    c.razon_social AS cliente_nombre
                  FROM trips t
                  JOIN drivers d        ON t.driver_id = d.id
                  JOIN places  p1       ON t.origin_id = p1.id
                  JOIN places  p2       ON t.destination_id = p2.id
                  LEFT JOIN customers c ON t.customer_id = c.id
                  ORDER BY t.id DESC";

          $stmt = $pdo->query($sql);

          foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $trip) {
            $chofer   = trim(($trip['driver_nombre'] ?? '').' '.($trip['driver_apellido'] ?? ''));
            $estado   = $trip['estado_viaje'] ?? 'Activo';
            $fact     = $trip['estado_facturacion'] ?? 'No Facturado';
            $pago     = $trip['estado_pago'] ?? 'No Pagado';
            $cliente  = $trip['cliente_nombre'] ?? '';
            $kms      = $trip['km_recorridos'] ?? '';

            $clsEstado = ($estado === 'Realizado') ? 'estado-ok' : 'estado-pend';

            switch ($fact) {
              case 'Facturado en Blanco':
              case 'Facturado en Negro':
              case 'Facturado':
                $clsFact = 'estado-ok';
                break;
              default:
                $clsFact = 'estado-pend';
                break;
            }

            $clsPago = (strcasecmp($pago, 'Pagado') === 0) ? 'estado-ok' : 'estado-pend';

            echo "<tr>";
            echo "<td>".htmlspecialchars($trip['id'])."</td>";
            echo "<td>".htmlspecialchars($chofer)."</td>";
            echo "<td>".htmlspecialchars($trip['origen_nombre'])."</td>";
            echo "<td>".htmlspecialchars($trip['destino_nombre'])."</td>";
            echo "<td>".htmlspecialchars($trip['fecha_origen'])."</td>";
            echo "<td class='d-none'>".htmlspecialchars($trip['fecha_destino'])."</td>";
            echo "<td class='d-none'>".htmlspecialchars($kms)."</td>";                   // Km oculto
            echo "<td>".htmlspecialchars($trip['tipo_transporte'])."</td>";
            echo "<td>".htmlspecialchars($cliente)."</td>";

            echo "<td class='text-center'><span class='{$clsEstado}'>".htmlspecialchars($estado)."</span></td>";
            echo "<td class='text-center'><span class='{$clsFact}'>".htmlspecialchars($fact)."</span></td>";

            echo "<td class='d-none'>".htmlspecialchars($trip['numero_factura'] ?? '')."</td>";

            echo "<td class='text-center'><span class='{$clsPago}'>".htmlspecialchars($pago)."</span></td>";

            echo "<td class='text-center'>
                    <a href='trip.php?id=".urlencode($trip['id'])."' class='btn-icon orange me-1' title='Ver'>
                      <i class='bi bi-eye'></i>
                    </a>
                    <a href='edit.php?id=".urlencode($trip['id'])."' class='btn-icon blue me-1' title='Editar'>
                      <i class='bi bi-pencil'></i>
                    </a>
                    <a href='delete.php?id=".urlencode($trip['id'])."' class='btn-icon red' title='Eliminar'
                       onclick='return confirm(\"¿Seguro deseas eliminar este viaje?\");'>
                      <i class='bi bi-trash'></i>
                    </a>
                  </td>";
            echo "</tr>";
          }
          ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- JS -->
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- DataTables + Buttons + JSZip -->
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>

<script>
$(document).ready(function () {
  var table = $('#tripsTable').DataTable({
    dom: "<'row mb-3'<'col-sm-6'l><'col-sm-6 d-flex justify-content-end'Bf>>" +
         "rt<'row mt-3'<'col-sm-6'i><'col-sm-6'p>>",
    buttons: [
      {
        extend: 'excelHtml5',
        text: 'Exportar Excel',
        className: 'btn btn-warning btn-sm text-white fw-bold',
        exportOptions: {
          // Exportamos hasta la columna Pago, incluyendo ocultas (Fecha Destino, Km, Nº Factura)
          // Índices: 0..12 -> ID, Chofer, Origen, Destino, Fecha Origen,
          //           Fecha Destino, Km, Tipo, Cliente, Estado, Facturación, Nº Factura, Pago
          columns: [0,1,2,3,4,5,6,7,8,9,10,11,12],
          format: {
            body: function (data) {
              var div = document.createElement('div');
              div.innerHTML = data;
              return div.textContent || div.innerText || '';
            }
          }
        }
      }
    ],
    pageLength: 50,
    order: [[0, 'desc']],
    language: { url: '//cdn.datatables.net/plug-ins/1.13.4/i18n/es-ES.json' },
    columnDefs: [
      { targets: -1, orderable: false },            // Acciones sin orden
      { targets: [5, 6, 11], visible: false }       // Fecha Destino, Km, Nº Factura ocultas en UI
    ]
  });

  // Evita duplicar botones exportar
  $('.dt-buttons').each(function() {
    const buttons = $(this).find('button');
    if (buttons.length > 1) {
      $(this).find('button:gt(0)').remove();
    }
  });

  // Filtros personalizados
  $('#filter_driver').on('keyup change', function(){
    table.column(1).search(this.value).draw();
  });
  $('#filter_origin').on('keyup change', function(){
    table.column(2).search(this.value).draw();
  });
  $('#filter_destination').on('keyup change', function(){
    table.column(3).search(this.value).draw();
  });

  // Rango de fechas (columna 4 = Fecha Origen)
  $('#filter_start_date, #filter_end_date').on('change', function() {
    table.draw();
  });

  $.fn.dataTable.ext.search.push(function(settings, data) {
    var start = $('#filter_start_date').val();
    var end   = $('#filter_end_date').val();
    var date  = data[4] || ''; // Fecha Origen

    if (!start && !end) return true;
    if (start && date < start) return false;
    if (end && date > end) return false;
    return true;
  });

  // Limpiar filtros
  $('#clear_filters').on('click', function() {
    $('#filter_driver, #filter_origin, #filter_destination, #filter_start_date, #filter_end_date').val('');
    table.search('').columns().search('').draw();
  });
});
</script>

<!-- Fix dropdown -->
<script>
  document.addEventListener('shown.bs.dropdown', function (event) {
    const menu = event.target.querySelector('.dropdown-menu');
    if (menu) {
      menu.style.position = 'absolute';
      menu.style.zIndex = 99999;
      menu.style.display = 'block';
    }
  });

  document.querySelectorAll('.dropdown').forEach(drop => {
    drop.addEventListener('show.bs.dropdown', function () {
      const menu = this.querySelector('.dropdown-menu');
      const rect = this.getBoundingClientRect();
      menu.style.top = rect.height + 'px';
      menu.style.left = '0';
      menu.style.position = 'absolute';
      menu.style.zIndex = '999999';
      menu.style.display = 'block';
    });
  });
</script>

</body>
</html>