<?php
session_start();
require_once '../../config/db.php';

// Verificar que se haya pasado el ID, por ejemplo por GET
$id = $_GET['id'] ?? null;
if (!$id) {
    $_SESSION['error'] = "ID no especificado";
    header("Location: index.php");
    exit;
}

// 1) Obtener los datos completos del viaje a eliminar
$stmtOld = $pdo->prepare("SELECT * FROM trips WHERE id = :id LIMIT 1");
$stmtOld->execute(['id' => $id]);
$oldData = $stmtOld->fetch(PDO::FETCH_ASSOC);
if (!$oldData) {
    $_SESSION['error'] = "Viaje no encontrado";
    header("Location: index.php");
    exit;
}

// 2) Eliminar el registro de la BD
$stmt = $pdo->prepare("DELETE FROM trips WHERE id = :id");
$stmt->execute(['id' => $id]);

// 3) Convertir los datos eliminados a JSON para registrar en 'cambios'
$cambios = json_encode($oldData);

// 4) Insertar en logs la eliminación (tipo 3, por ejemplo)
$log_sql = "INSERT INTO logs (grupo, tipo, id_modif, user, cambios, fecha) 
            VALUES ('Viaje', 3, :trip_id, :user, :cambios, NOW())";
$log_stmt = $pdo->prepare($log_sql);
$log_stmt->execute([
    'trip_id' => $id,
    'user'    => $_SESSION['user_id'],
    'cambios' => $cambios
]);

// 5) Redirigir con mensaje de éxito
$_SESSION['success'] = "¡Viaje eliminado con éxito!";
header("Location: index.php");
exit;
?>
