<?php
/**
 * public/trips/create.php
 * Formulario Crear Viaje - versión con 3 bloques + autocompletados + resumen automático
 */
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

/* Próximo número de viaje (AUTO_INCREMENT o MAX(id)+1 como fallback) */
$nextTripId = null;
try {
  $dbName = $pdo->query("SELECT DATABASE()")->fetchColumn();
  $stmtAI = $pdo->prepare("
    SELECT AUTO_INCREMENT
    FROM INFORMATION_SCHEMA.TABLES
    WHERE TABLE_SCHEMA = :db AND TABLE_NAME = 'trips'
    LIMIT 1
  ");
  $stmtAI->execute(['db' => $dbName]);
  $nextTripId = (int) $stmtAI->fetchColumn();
  if (!$nextTripId) {
    $nextTripId = (int) $pdo->query("SELECT COALESCE(MAX(id),0)+1 AS next_id FROM trips")->fetchColumn();
  }
} catch (Throwable $e) {
  $nextTripId = null;
}
?>
<!DOCTYPE html>
<html lang="es" class="h-full bg-white">
<head>
  <meta charset="utf-8">
  <title>Crear Viaje</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/select2@4/dist/css/select2.min.css" rel="stylesheet" />
  <style>
    :root { --nav-bg:#1f2b35; --brand-blue:#0d6efd; }
    .main-navbar { background:var(--nav-bg); border-bottom:1px solid rgba(0,0,0,.15); position:fixed; top:0; left:0; width:100%; z-index:1080; height:64px; }
    .content-wrap { margin-top:82px; }
    .select2-container--default .select2-selection--single { height:36px; padding:4px 8px; border-radius:4px; border:1px solid #d1d5db; }
    .block-title{font-weight:600;font-size:.95rem;color:#374151;margin-bottom:.4rem}
    .box{padding:.6rem;border:1px solid #e5e7eb;border-radius:6px;background:#fff}
    /* FIX: mostrar el menú cuando Tailwind está activo */
    .navbar .collapse { visibility: visible !important; }
  </style>
</head>
<body class="h-full bg-white flex flex-col">
  <?php include "../assets/nav2.php"; ?>

  <main class="content-wrap">
    <div class="container mx-auto px-4 py-6">
      <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="px-6 py-5 flex items-center justify-between">
          <div>
            <h1 class="text-lg font-medium text-gray-900">Crear Nuevo Viaje</h1>
            <p class="text-sm text-gray-500">
              Ingrese los detalles del viaje
              <?php if (!empty($nextTripId)): ?>
                <span class="ms-2 text-xl fw-bold text-dark">#<?= htmlspecialchars($nextTripId) ?></span>
              <?php endif; ?>
            </p>
          </div>
        </div>

        <div class="border-t border-gray-200 px-6 py-6">
          <form id="tripForm" action="store.php" method="POST" enctype="multipart/form-data">
            <!-- === BLOQUES SUPERIORES: 3 columnas === -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
              <!-- Columna 1 -->
              <div class="box">
                <div class="block-title">Datos de alta del viaje</div>

                <!-- Cliente -->
                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Cliente (obligatorio)</label>
                  <div class="flex gap-2">
                    <select id="customer_id" name="customer_id" class="w-full select-customers"></select>
                    <a href="../customers/create.php" target="_blank" class="bg-blue-600 text-white px-3 rounded">Agregar</a>
                  </div>
                </div>

                <!-- Chofer -->
                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Chofer (obligatorio)</label>
                  <select id="driver_id" name="driver_id" class="w-full select-drivers"></select>
                </div>

                <!-- Origen -->
                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Origen (obligatorio)</label>
                  <select id="origin_id" name="origin_id" class="w-full select-places"></select>
                </div>

                <!-- Destino -->
                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Destino (obligatorio)</label>
                  <select id="destination_id" name="destination_id" class="w-full select-places"></select>
                </div>

                <!-- Mercadería -->
                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Mercadería</label>
                  <input type="text" id="mercaderia" name="mercaderia" class="w-full border rounded p-2 text-sm" placeholder="Ej: Soja, Maíz, Cemento...">
                </div>

                <!-- Toneladas de Carga -->
                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Toneladas de Carga</label>
                  <input type="number" step="0.01" id="toneladas_carga" name="toneladas_carga" class="w-full border rounded p-2 text-sm">
                </div>

                <!-- Fecha Origen -->
                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Fecha Origen</label>
                  <input type="date" id="fecha_origen" name="fecha_origen" class="w-full border rounded p-2 text-sm">
                </div>

                <!-- Tarifa Real -->
                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Tarifa Real</label>
                  <input type="number" step="0.01" id="tarifa_real" name="tarifa_real" class="w-full border rounded p-2 text-sm">
                </div>

                <!-- Kilómetros -->
                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Kilómetros</label>
                  <input type="number" id="km_recorridos" name="km_recorridos" class="w-full border rounded p-2 text-sm">
                </div>

                <!-- CTG / N° de RM -->
                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">CTG / N° de RM</label>
                  <div>
                    <input type="text" id="ctg_num" class="w-full border rounded p-2 text-sm" placeholder="Ej: 10226832486 o RM-4567">
                    <input type="text" id="ctg_text" class="w-full border rounded p-2 text-sm hidden mt-2" placeholder="Ej: 10226832486 o RM-4567">
                    <input type="hidden" id="ctg" name="ctg">
                    <div class="mt-2">
                      <button type="button" id="ctg_toggle" class="px-3 py-1 text-xs bg-gray-700 text-white rounded">ABC</button>
                      <span class="text-xs text-gray-500 ml-2">Toque ABC/123 para cambiar de teclado.</span>
                    </div>
                  </div>
                </div>

                <!-- Transporte -->
                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Transporte</label>
                  <select id="tipo_transporte" name="tipo_transporte" class="w-full border rounded p-2 text-sm">
                    <option value="Transporte">Transporte</option>
                    <option value="Directo">Directo</option>
                    <option value="Liquido-Producto">Líquido Producto</option>
                    <option value="Arrime">Arrime</option>
                  </select>
                </div>
              </div>

              <!-- Columna 2 -->
              <div class="box">
                <div class="block-title">Datos de final del viaje</div>

                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Fecha Destino</label>
                  <input type="date" id="fecha_destino" name="fecha_destino" class="w-full border rounded p-2 text-sm">
                </div>

                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Tarifa Rendida</label>
                  <input type="number" step="0.01" id="tarifa_rendida" name="tarifa_rendida" class="w-full border rounded p-2 text-sm">
                </div>

                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Toneladas de descarga</label>
                  <input type="number" step="0.01" id="toneladas" name="toneladas" class="w-full border rounded p-2 text-sm">
                </div>

                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Estado Viaje</label>
                  <select id="estado_viaje" name="estado_viaje" class="w-full border rounded p-2 text-sm">
                    <option value="Activo">Activo</option>
                    <option value="Realizado">Realizado</option>
                  </select>
                </div>

                <div class="mb-3"><!-- espacio para futuros campos --></div>
              </div>

              <!-- Columna 3 -->
              <div class="box">
                <div class="block-title">Datos para facturación</div>

                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">CUIT</label>
                  <input type="text" id="cuit_facturacion" name="cuit_facturacion" readonly class="w-full bg-gray-50 border rounded p-2 text-sm">
                </div>

                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Cliente</label>
                  <input type="text" id="cliente_fact" name="cliente_fact" readonly class="w-full bg-gray-50 border rounded p-2 text-sm">
                </div>

                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Chofer</label>
                  <input type="text" id="chofer_fact" name="chofer_fact" readonly class="w-full bg-gray-50 border rounded p-2 text-sm">
                </div>

                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Tarifa Real (facturación)</label>
                  <input type="text" id="tarifa_fact" name="tarifa_fact" readonly class="w-full bg-gray-50 border rounded p-2 text-sm">
                </div>

                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Email principal</label>
                  <input type="text" id="email_facturacion" name="email_facturacion" readonly class="w-full bg-gray-50 border rounded p-2 text-sm">
                </div>

                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Teléfono</label>
                  <input type="text" id="telefono_facturacion" name="telefono_facturacion" readonly class="w-full bg-gray-50 border rounded p-2 text-sm">
                </div>

                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Medio de pago habitual</label>
                  <input type="text" id="medio_pago_facturacion" name="medio_pago_facturacion" readonly class="w-full bg-gray-50 border rounded p-2 text-sm">
                </div>

                <!-- Facturación -->
                <div class="mb-3">
                  <label class="text-sm text-gray-600 block mb-1">Facturación (obligatorio)</label>
                  <select id="estado_facturacion" name="estado_facturacion" class="w-full border rounded p-2 text-sm" required>
                    <option value="No Facturado">No Facturado</option>
                    <option value="Facturado en Blanco">Facturado en Blanco</option>
                    <option value="Facturado en Negro">Facturado en Negro</option>
                  </select>
                </div>

                <!-- NUEVO: N° de Factura (visible solo si está facturado) -->
                <div class="mb-3" id="wrapper_numero_factura" style="display:none;">
                  <label class="text-sm text-gray-600 block mb-1">N° de Factura</label>
                  <input
                    type="text"
                    id="numero_factura"
                    name="numero_factura"
                    class="w-full border rounded p-2 text-sm"
                    placeholder="Ej: A-0001-00001234 / 0001-12345678"
                    inputmode="text"
                  >
                  <div class="form-text text-muted" style="font-size:.8rem;">
                    Se permite letras, números, guiones y “/”.
                  </div>
                </div>
              </div>
            </div>
            <!-- /3 columnas -->

            <!-- Comentario -->
            <div class="mt-6">
              <label class="block text-sm text-gray-600 mb-2">Comentario</label>
              <textarea id="comentario" name="comentario" rows="4" class="w-full border rounded p-2 text-sm" placeholder="Observaciones o instrucciones..."></textarea>
            </div>

            <!-- Resumen -->
            <div class="mt-4">
              <label class="block text-sm text-gray-600 mb-2">Resumen del viaje</label>
              <div id="resumen_linea" class="min-h-[48px] border rounded p-2 bg-white text-sm"></div>
              <input type="hidden" id="linea_factura" name="linea_factura">
            </div>

            <!-- Archivos -->
            <div class="mt-6 grid grid-cols-1 gap-4">
              <?php for($i=1;$i<=5;$i++): ?>
                <div class="flex items-center gap-4">
                  <label class="w-1/6 text-sm text-gray-600">Archivo <?= $i ?>:</label>
                  <input type="file" name="foto<?= $i ?>" accept="image/*,application/pdf" class="w-5/6 border rounded p-2 text-sm">
                </div>
              <?php endfor; ?>
            </div>

            <!-- Botones -->
            <div class="mt-6 flex justify-center gap-4">
              <a href="index.php" class="bg-gray-400 text-black py-2 px-4 rounded">Volver a Viajes</a>
              <button type="submit" class="bg-blue-600 text-white py-2 px-4 rounded hover:bg-blue-700">Guardar Viaje</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </main>

  <?php include "../assets/footer.php"; ?>

  <!-- JS libs -->
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/select2@4/dist/js/select2.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

  <script>
  (function(){
    // ---- Select2 clientes (AJAX) ----
    $('.select-customers').select2({
      placeholder: 'Seleccione un cliente',
      ajax: {
        url: '../customers/search_customers.php',
        dataType: 'json',
        delay: 250,
        data: params => ({ term: params.term }),
        processResults: data => ({ results: data })
      },
      templateResult: function(item){
        if (!item.id) return item.text;
        return $('<span>' + (item.razon_social || item.text) + (item.cuit? ' <small class="text-gray-500">('+item.cuit+')</small>':'') + '</span>');
      },
      templateSelection: function(item){ return item.razon_social || item.text || ''; }
    });

    // ---- Select2 choferes y lugares ----
    $('.select-drivers').select2({
      placeholder: 'Seleccione un chofer',
      ajax: { url: 'search_drivers.php', dataType:'json', delay:250, data: params=>({term:params.term}), processResults: data => ({ results: data }) }
    });
    $('.select-places').select2({
      placeholder: 'Seleccione un lugar',
      ajax: { url: 'search_places.php', dataType:'json', delay:250, data: params=>({term:params.term}), processResults: data => ({ results: data }) }
    });

    function getSelect2Text($sel){
      try { var d=$sel.select2('data'); if(d && d.length){ return (d[0].razon_social||d[0].text||'').trim(); } } catch(e){}
      return '';
    }

    // ---- Completar datos de facturación al elegir cliente ----
    $('.select-customers').on('select2:select', function(e){
      var id = e.params.data.id; if(!id) return;
      $.getJSON('../customers/get_cliente.php?id=' + encodeURIComponent(id), function(resp){
        if(!resp) return;
        var c = resp.cliente || resp.data || resp; if (Array.isArray(c)) c = c[0] || {};
        $('#cuit_facturacion').val(c.cuit || c.CUIT || '');
        $('#email_facturacion').val(c.email || c.mail || '');
        $('#telefono_facturacion').val(c.telefono || c.celular || '');
        $('#medio_pago_facturacion').val(c.medio_pago || c.medio_pago_habitual || '');
        $('#cliente_fact').val(c.razon_social || c.nombre || getSelect2Text($('.select-customers')));

        var sel = e.params.data || {};
        var comentarioSel = sel.comentario_predefinido || sel.comentario_predef || sel.comentario || sel.nota || sel.obs || '';
        var comentarioCliente = c.comentario_predefinido || c.comentario_predef || c.comentario || c.nota || c.obs || comentarioSel || '';
        if($('#comentario').val().trim() === '') {
          $('#comentario').val(comentarioCliente);
        }
        updateSummary();
      });
    });

    // ---- CTG toggle ABC/123 ----
    (function(){
      var num = document.getElementById('ctg_num');
      var txt = document.getElementById('ctg_text');
      var hid = document.getElementById('ctg');
      var btn = document.getElementById('ctg_toggle');
      if(!num || !txt || !hid || !btn) return;
      var mode = 'num';
      function syncHidden(){ hid.value = (mode === 'num' ? num.value : txt.value); updateSummary(); }
      num.addEventListener('input', syncHidden);
      txt.addEventListener('input', syncHidden);
      btn.addEventListener('click', function(){
        if(mode === 'num'){ txt.value = num.value; num.classList.add('hidden'); txt.classList.remove('hidden'); mode='txt'; btn.textContent='123'; txt.focus(); }
        else { num.value = txt.value; txt.classList.add('hidden'); num.classList.remove('hidden'); mode='num'; btn.textContent='ABC'; num.focus(); }
        syncHidden();
      });
      syncHidden();
      var form = document.getElementById('tripForm');
      if(form) form.addEventListener('submit', function(){ syncHidden(); updateSummary(); });
    })();

    // ---- Mostrar/ocultar N° de Factura según estado ----
    function toggleNumeroFactura(){
      var v = $('#estado_facturacion').val();
      var show = (v === 'Facturado en Blanco' || v === 'Facturado en Negro');
      $('#wrapper_numero_factura').css('display', show ? '' : 'none');

      // Si lo querés OBLIGATORIO cuando está facturado, descomentá esta línea:
      // $('#numero_factura').prop('required', show);

      if(!show){
        $('#numero_factura').val('');
      }
    }
    $('#estado_facturacion').on('change', toggleNumeroFactura);
    toggleNumeroFactura(); // inicial

    // Normalizar N° de Factura (solo letras, números, guiones y “/”)
    $('#numero_factura').on('input', function(){
      var v = $(this).val().toUpperCase();
      v = v.replace(/[^A-Z0-9\-\/]/g, '');
      $(this).val(v);
    });

    // ---- Resumen automático (linea_factura) ----
    function formatDateToDDMMYYYY(dateStr){
      if(!dateStr) return '';
      var parts = dateStr.split('-');
      if (parts.length === 3) {
        var yyyy = parts[0], mm = parts[1], dd = parts[2];
        dd = dd.padStart(2,'0'); mm = mm.padStart(2,'0');
        return dd + '/' + mm + '/' + yyyy;
      }
      return dateStr;
    }

    function getSelectText(id){
      var s = document.getElementById(id);
      if(!s) return '';
      var opt = s.options[s.selectedIndex];
      return opt ? opt.text : '';
    }

    function updateSummary(){
      var merc = ($('#mercaderia').val() || '').trim();
      var ctg  = ($('#ctg').val() || '').trim();
      var origen  = getSelectText('origin_id') || getSelect2Text($('#origin_id'));
      var destino = getSelectText('destination_id') || getSelect2Text($('#destination_id'));
      var fechaDesc = formatDateToDDMMYYYY($('#fecha_destino').val());

      var parts = [];
      parts.push(merc ? ('Viaje de ' + merc) : 'Viaje');
      if (ctg) parts.push('Según CTG/N° de RM ' + ctg);
      if(origen)  parts.push('Origen: ' + origen);
      if(destino) parts.push('Destino: ' + destino);
      if(fechaDesc) parts.push('Fecha de Descarga: ' + fechaDesc);

      var final = parts.join(' – ');
      $('#resumen_linea').text(final);
      $('#linea_factura').val(final);

      $('#tarifa_fact').val($('#tarifa_real').val());
      var custText   = getSelect2Text($('.select-customers'));
      var driverText = getSelect2Text($('.select-drivers'));
      if(custText)   $('#cliente_fact').val(custText);
      if(driverText) $('#chofer_fact').val(driverText);
    }

    $('#mercaderia, #fecha_destino, #tarifa_real, #toneladas').on('input change', updateSummary);
    $('#ctg, #km_recorridos, #tarifa_rendida').on('input change', updateSummary);
    $('#origin_id, #destination_id').on('change', updateSummary);
    $('.select-places, .select-drivers, .select-customers').on('select2:select', updateSummary);

    $(document).ready(function(){ updateSummary(); });
  })();
  </script>
</body>
</html>