<?php
session_start();
require_once "../config/db.php";
require_once "../helpers/functions.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 1) Obtener datos del formulario
    $username = trim($_POST['username'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $password_confirm = $_POST['password_confirm'] ?? '';

    // 2) Validar contraseñas
    if ($password !== $password_confirm) {
        // Contraseñas no coinciden
        redirect('register.php?error=1');
    }

    // 3) Verificar si el username o el email ya existen
    $sqlCheck = "SELECT COUNT(*) FROM users WHERE username = :username OR email = :email";
    $stmtCheck = $pdo->prepare($sqlCheck);
    $stmtCheck->execute(['username' => $username, 'email' => $email]);
    $countExisting = $stmtCheck->fetchColumn();

    if ($countExisting > 0) {
        // Ya existe un usuario con el mismo username o email
        redirect('register.php?error=2');
    }

    // 4) Crear el hash de la contraseña
    $passwordHash = password_hash($password, PASSWORD_DEFAULT);

    // 5) Insertar en la base de datos
    try {
        $sqlInsert = "INSERT INTO users (username, email, password) 
                      VALUES (:username, :email, :password)";
        $stmtInsert = $pdo->prepare($sqlInsert);
        $stmtInsert->execute([
            'username' => $username,
            'email'    => $email,
            'password' => $passwordHash
        ]);

        // Redirigir al login (o loguear automáticamente si prefieres)
        redirect('login.php');
    } catch (Exception $e) {
        // Error genérico, por ejemplo si la BD falla
        redirect('register.php?error=3');
    }

} else {
    // Si alguien llega aquí sin usar el formulario POST, redirigimos
    redirect('register.php');
}
