<?php
session_start();
require_once "../config/db.php";
require_once "../helpers/functions.php";

// Si el usuario ya está logueado, lo redirigimos al dashboard (opcional)
if (!empty($_SESSION['user_id'])) {
    redirect('dashboard.php');
}

?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Registro de Usuario</title>
  <!-- Tailwind vía CDN (opcional) -->
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center h-screen">

<div class="bg-white p-6 rounded shadow-md w-full max-w-md">
  <h1 class="text-xl mb-4 font-bold">Crear Cuenta</h1>

  <!-- Mensajes de error (opcional) -->
  <?php if (isset($_GET['error'])): ?>
      <div class="text-red-500 mb-4">
        <?php 
          if ($_GET['error'] == 1) {
              echo "Las contraseñas no coinciden.";
          } elseif ($_GET['error'] == 2) {
              echo "Ese nombre de usuario o email ya está en uso.";
          } elseif ($_GET['error'] == 3) {
              echo "Ocurrió un error al intentar crear la cuenta. Inténtalo de nuevo.";
          }
        ?>
      </div>
  <?php endif; ?>

  <form action="register_process.php" method="POST" class="space-y-4">
    <div>
      <label class="block mb-1" for="username">Nombre de Usuario</label>
      <input 
        type="text" 
        name="username" 
        id="username" 
        class="w-full border border-gray-300 p-2 rounded" 
        required
      />
    </div>
    <div>
      <label class="block mb-1" for="email">Email</label>
      <input 
        type="email" 
        name="email" 
        id="email" 
        class="w-full border border-gray-300 p-2 rounded" 
        required
      />
    </div>
    <div>
      <label class="block mb-1" for="password">Contraseña</label>
      <input 
        type="password" 
        name="password" 
        id="password" 
        class="w-full border border-gray-300 p-2 rounded" 
        required
      />
    </div>
    <div>
      <label class="block mb-1" for="password_confirm">Confirmar Contraseña</label>
      <input 
        type="password" 
        name="password_confirm" 
        id="password_confirm" 
        class="w-full border border-gray-300 p-2 rounded" 
        required
      />
    </div>

    <button 
      type="submit" 
      class="w-full bg-blue-600 text-white py-2 rounded hover:bg-blue-700">
      Registrarme
    </button>
  </form>

  <p class="mt-4 text-gray-600">
    ¿Ya tienes una cuenta?
    <a href="login.php" class="text-blue-600 hover:underline">Inicia sesión</a>
  </p>
</div>

</body>
</html>
