<?php
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header('Location: index.php');
  exit;
}

// 1) Sanitizar/validar entrada
$id      = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$nombre  = isset($_POST['nombre']) ? trim($_POST['nombre']) : '';

if ($id <= 0) {
  $_SESSION['error'] = 'ID inválido.';
  header('Location: index.php');
  exit;
}
if ($nombre === '') {
  $_SESSION['error'] = 'El nombre no puede estar vacío.';
  header('Location: edit.php?id=' . urlencode($id));
  exit;
}

try {
  // 2) Obtener valor anterior (para log de cambios)
  $stmtOld = $pdo->prepare('SELECT nombre FROM places WHERE id = :id LIMIT 1');
  $stmtOld->execute(['id' => $id]);
  $old = $stmtOld->fetch(PDO::FETCH_ASSOC);
  $oldNombre = $old ? ($old['nombre'] ?? '') : '';

  // 3) Actualizar registro
  $stmt = $pdo->prepare('UPDATE places SET nombre = :nombre, updated_at = NOW() WHERE id = :id');
  $stmt->execute(['nombre' => $nombre, 'id' => $id]);

  // 4) Armar diferencias para logs (solo si cambió)
  $diff = [];
  if ($oldNombre !== $nombre) {
    $diff['nombre'] = ['old' => $oldNombre, 'new' => $nombre];
  }

  if (!empty($diff)) {
    $log_sql = 'INSERT INTO logs (grupo, tipo, id_modif, user, cambios, fecha)
                VALUES ("Lugar", 2, :place_id, :user, :cambios, NOW())';
    $pdo->prepare($log_sql)->execute([
      'place_id' => $id,
      'user'     => $_SESSION['user_id'] ?? 0,
      'cambios'  => json_encode($diff, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
    ]);
  }

  // 5) Mensaje y redirección
  $_SESSION['success'] = 'Lugar actualizado correctamente.';
  header('Location: index.php');
  exit;

} catch (Throwable $e) {
  // Opcional: error_log($e->getMessage());
  $_SESSION['error'] = 'Ocurrió un error al actualizar el lugar.';
  header('Location: edit.php?id=' . urlencode($id));
  exit;
}