<?php
session_start();
require_once '../../config/db.php';

// Establecer el Content-Type a JSON
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Recoger el dato del formulario
        $nombre = $_POST['nombre'] ?? '';

        // Insertar el nuevo lugar en la tabla places
        $stmt = $pdo->prepare("INSERT INTO places (nombre, created_at, updated_at, estado) VALUES (:nombre, NOW(), NOW(), :estado)");
        $stmt->execute([
            'nombre' => $nombre,
            'estado' => 0
        ]);

        // Obtener el ID del lugar insertado
        $place_id = $pdo->lastInsertId();

        // Construir los datos para el log
        $cambios = json_encode(['nombre' => $nombre]);

        // Insertar en logs la creación (tipo 1)
        $log_sql = "INSERT INTO logs (grupo, tipo, id_modif, user, cambios, fecha) VALUES ('Lugar', 1, :place_id, :user, :cambios, NOW())";
        $log_stmt = $pdo->prepare($log_sql);
        $log_stmt->execute([
            'place_id' => $place_id,
            'user'     => $_SESSION['user_id'] ?? 0,
            'cambios'  => $cambios
        ]);

        // Retornar la respuesta JSON con los datos del nuevo lugar
        echo json_encode([
            'success' => true,
            'data'    => [
                'id'     => $place_id,
                'nombre' => $nombre
            ]
        ]);
        exit;
    } catch (Exception $e) {
        // En caso de error, retornar el error en JSON
        echo json_encode([
            'success' => false,
            'error'   => $e->getMessage()
        ]);
        exit;
    }
} else {
    echo json_encode([
        'success' => false,
        'error'   => 'Método no permitido'
    ]);
    exit;
}
