<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nombre = $_POST['nombre'];

    // Insertar el nuevo lugar
    $stmt = $pdo->prepare("INSERT INTO places (nombre, created_at, updated_at, estado) VALUES (:nombre, NOW(), NOW(), :estado)");
    $stmt->execute([
        'nombre' => $nombre,
        'estado' => 0
    ]);

    // Obtener el ID del lugar insertado
    $place_id = $pdo->lastInsertId();

    // Construir el JSON con los datos del registro (puedes incluir más campos si lo deseas)
    $cambios = json_encode(['nombre' => $nombre]);

    // Insertar en logs la creación (tipo 1)
    $log_sql = "INSERT INTO logs (grupo, tipo, id_modif, user, cambios, fecha) VALUES ('Lugar', 1, :place_id, :user, :cambios, NOW())";
    $log_stmt = $pdo->prepare($log_sql);
    $log_stmt->execute([
        'place_id' => $place_id,
        'user'     => $_SESSION['user_id'] ?? 0,
        'cambios'  => $cambios
    ]);

    header('Location: index.php');
    exit;
}
