<?php
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

// Lugares activos
$stmt = $pdo->query("SELECT * FROM places WHERE estado = 0");
$places = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="es" class="h-full bg-white">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Lugares - Macher</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Bootstrap Icons -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
  <!-- DataTables (Bootstrap 5 skin) -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">

  <style>
    body { background-color: #f8f9fa; font-family: "Inter", sans-serif; }
    .content-wrap { margin-top: 82px; padding-bottom: 40px; }

    /* Forzar visibilidad del menú móvil (Tailwind a veces lo oculta) */
    .navbar .collapse { visibility: visible !important; }

    /* Botones (hover sin “saltito”) */
    .btn { transition: filter .15s ease; }
    .btn:hover, .btn:active, .btn:focus { transform: none !important; filter: brightness(0.9); }
    .btn i { font-size: 1rem; }

    /* =========================
       PAGINACIÓN (Bootstrap 5)
       ========================= */
    /* Normal: fondo negro, texto blanco */
    .dataTables_wrapper .dataTables_paginate ul.pagination .page-item .page-link {
      background-color: #000 !important;
      color: #fff !important;
      border: 1px solid #000 !important;
      border-radius: 4px !important;
      margin: 0 2px !important;
      padding: 6px 12px !important;
      line-height: 1.2 !important;
    }
    /* Hover: un poco más claro */
    .dataTables_wrapper .dataTables_paginate ul.pagination .page-item .page-link:hover {
      filter: brightness(1.25);
      color: #fff !important;
      text-decoration: none !important;
    }
    /* Activa: naranja corporativo */
    .dataTables_wrapper .dataTables_paginate ul.pagination .page-item.active .page-link {
      background-color: #f68b1e !important;
      border-color: #f68b1e !important;
      color: #fff !important;
    }
    /* Deshabilitados */
    .dataTables_wrapper .dataTables_paginate ul.pagination .page-item.disabled .page-link {
      background-color: #000 !important;
      color: #bbb !important;
      opacity: 0.6;
      cursor: not-allowed;
    }

    table.dataTable td { vertical-align: middle; }
  </style>
</head>
<body class="h-full bg-white flex flex-col">

  <!-- Header único -->
  <?php include "../assets/nav2.php"; ?>

  <main class="content-wrap container">
    <div class="card shadow-sm">
      <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0 text-primary fw-bold">Listado de Lugares</h5>
        <a href="create.php" class="btn btn-primary btn-sm text-white d-flex align-items-center gap-1">
          <i class="bi bi-plus-lg"></i> Agregar Lugar
        </a>
      </div>

      <div class="card-body">
        <div class="table-responsive">
          <table id="placesTable" class="table table-striped table-hover align-middle">
            <thead class="table-light">
              <tr>
                <th>ID</th>
                <th>Nombre</th>
                <th class="text-center">Acciones</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($places as $place): ?>
                <tr>
                  <td><?= htmlspecialchars($place['id']) ?></td>
                  <td><?= htmlspecialchars($place['nombre']) ?></td>
                  <td class="text-center">
                    <div class="d-flex justify-content-center gap-2">
                      <!-- Editar (ícono solo, azul) -->
                      <a href="edit.php?id=<?= $place['id'] ?>" class="btn btn-primary btn-sm text-white" title="Editar">
                        <i class="bi bi-pencil"></i>
                      </a>
                      <!-- Eliminar (ícono solo, rojo) -->
                      <a href="delete.php?id=<?= $place['id'] ?>" class="btn btn-danger btn-sm text-white"
                         title="Eliminar"
                         onclick="return confirm('¿Está seguro de querer eliminar este lugar?');">
                        <i class="bi bi-trash"></i>
                      </a>
                    </div>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </main>

  <?php include "../assets/footer.php"; ?>

  <!-- JS -->
  <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>

  <script>
    $(document).ready(function() {
      $('#placesTable').DataTable({
        language: {
          emptyTable: "No hay información",
          info: "Mostrando _START_ a _END_ de _TOTAL_ lugares",
          infoEmpty: "Mostrando 0 a 0 de 0 lugares",
          infoFiltered: "(filtrado de _MAX_ lugares en total)",
          lengthMenu: "Mostrar _MENU_ lugares",
          search: "Buscar:",
          zeroRecords: "No se encontraron lugares",
          paginate: { first: "Primero", last: "Último", next: "Siguiente", previous: "Anterior" }
        },
        pageLength: 10,
        lengthMenu: [5, 10, 25, 50, 100]
      });
    });
  </script>
</body>
</html>