<?php
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

// Validar ID
$id = $_GET['id'] ?? null;
if (!$id) {
  header('Location: index.php');
  exit;
}

// Buscar lugar
$stmt = $pdo->prepare("SELECT * FROM places WHERE id = :id LIMIT 1");
$stmt->execute(['id' => $id]);
$place = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$place) {
  $_SESSION['error'] = "Lugar no encontrado.";
  header('Location: index.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="es" class="h-full bg-white">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Editar Lugar - Macher</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Bootstrap Icons -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

  <style>
    body {
      background-color: #f8f9fa;
      font-family: "Inter", sans-serif;
    }
    .content-wrap {
      margin-top: 82px;
      padding-bottom: 40px;
    }
    .navbar .collapse { visibility: visible !important; }
    .btn { transition: filter .15s ease; }
    .btn:hover { filter: brightness(0.9); }
  </style>
</head>
<body class="h-full bg-white flex flex-col">
  <?php include "../assets/nav2.php"; ?>

  <main class="content-wrap container">
    <div class="card shadow-sm">
      <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0 text-primary fw-bold">
          <i class="bi bi-pencil-square me-2"></i>Editar Lugar
        </h5>
      </div>

      <div class="card-body">
        <p class="text-muted mb-4">Modifique el nombre del lugar y presione <strong>Guardar Cambios</strong>.</p>

        <form action="update.php" method="POST" class="row g-3">
          <input type="hidden" name="id" value="<?= htmlspecialchars($place['id']) ?>">

          <div class="col-md-12">
            <label for="nombre" class="form-label fw-semibold">Nombre del Lugar</label>
            <input type="text" id="nombre" name="nombre" required class="form-control"
                   value="<?= htmlspecialchars($place['nombre']) ?>">
          </div>

          <!-- Botones -->
          <div class="col-12 d-flex justify-content-center mt-4 gap-3">
            <a href="index.php" class="btn btn-dark text-white px-4">
              <i class="bi bi-arrow-left"></i> Volver
            </a>
            <button type="submit" class="btn btn-primary text-white px-4">
              <i class="bi bi-save"></i> Guardar Cambios
            </button>
          </div>
        </form>
      </div>
    </div>
  </main>

  <?php include "../assets/footer.php"; ?>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>