<?php
// Habilitar la visualización de errores en modo desarrollo
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require_once '../../config/db.php';

$id = $_GET['id'] ?? '';

if ($id) {
    // 1) Obtener los datos antiguos del lugar (para logs)
    $stmtOld = $pdo->prepare("SELECT * FROM places WHERE id = :id LIMIT 1");
    $stmtOld->execute(['id' => $id]);
    $oldData = $stmtOld->fetch(PDO::FETCH_ASSOC);

    // 2) Verificar si el lugar ha sido usado en trips (como origen o destino)
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM trips WHERE origin_id = :id OR destination_id = :id");
    if (!$stmt->execute(['id' => $id])) {
        echo "Error al ejecutar la consulta de conteo: " . implode(" ", $stmt->errorInfo());
        exit;
    }
    
    $tripCount = $stmt->fetchColumn();
    if ($tripCount === false) {
        echo "Error al obtener el conteo de viajes: " . implode(" ", $stmt->errorInfo());
        exit;
    }

    // 3) Si el lugar está en uso, se hace soft delete (actualiza estado a 1)
    if ($tripCount > 0) {
        $stmt = $pdo->prepare("UPDATE places SET estado = 1, updated_at = NOW() WHERE id = :id");
        if (!$stmt->execute(['id' => $id])) {
            echo "Error al actualizar el estado: " . implode(" ", $stmt->errorInfo());
            exit;
        }
        
        // Preparar diferencia: se cambia 'estado' de lo que tenía a 1
        $diff = [
            'estado' => [
                'old' => $oldData['estado'],
                'new' => 1
            ]
        ];
        $cambios = json_encode($diff);

        // Insertar en logs (tipo 3: eliminación/soft delete)
        $log_sql = "INSERT INTO logs (grupo, tipo, id_modif, user, cambios, fecha) 
                    VALUES ('Lugar', 3, :place_id, :user, :cambios, NOW())";
        $log_stmt = $pdo->prepare($log_sql);
        $log_stmt->execute([
            'place_id' => $id,
            'user'     => $_SESSION['user_id'] ?? 0,
            'cambios'  => $cambios
        ]);
    } else {
        // 4) Si no tiene viajes asociados, se elimina físicamente.
        // Guardar los datos completos del lugar para el log.
        $cambios = json_encode($oldData);

        $stmt = $pdo->prepare("DELETE FROM places WHERE id = :id");
        if (!$stmt->execute(['id' => $id])) {
            echo "Error al eliminar el registro: " . implode(" ", $stmt->errorInfo());
            exit;
        }

        // Insertar en logs la eliminación física
        $log_sql = "INSERT INTO logs (grupo, tipo, id_modif, user, cambios, fecha) 
                    VALUES ('Lugar', 3, :place_id, :user, :cambios, NOW())";
        $log_stmt = $pdo->prepare($log_sql);
        $log_stmt->execute([
            'place_id' => $id,
            'user'     => $_SESSION['user_id'] ?? 0,
            'cambios'  => $cambios
        ]);
    }
}

header('Location: index.php');
exit;
