<?php
session_start();
require_once "../config/db.php";
require_once "../helpers/functions.php";

// Consulta para obtener los logs junto con el nombre y apellido del usuario
$stmt = $pdo->query("
    SELECT 
        l.id, 
        l.grupo, 
        l.tipo, 
        l.id_modif, 
        l.cambios, 
        l.fecha, 
        u.nombre AS user_nombre, 
        u.apellido AS user_apellido 
    FROM logs l 
    LEFT JOIN users u ON l.user = u.id 
    ORDER BY l.fecha DESC
");
$logs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="es" class="h-full bg-white">
<head>
  <meta charset="UTF-8">
  <title>Logs</title>
  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
  
  <!-- DataTables CSS -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
  <!-- DataTables Buttons CSS (para CSV/Excel) -->
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
  
  <style>
    body {
      background-color: #fff;
      font-family: 'Inter', sans-serif;
    }
    .dataTables_wrapper,
    .dataTables_wrapper .dataTables_filter,
    .dataTables_wrapper .dataTables_length,
    .dataTables_wrapper .dataTables_info,
    .dataTables_wrapper .dataTables_paginate {
      font-size: 0.875rem;
      line-height: 1.25rem;
      color: #374151;
      font-family: inherit;
    }
    .dataTables_wrapper .dataTables_filter input {
      font-size: inherit;
      line-height: inherit;
      color: inherit;
      font-family: inherit;
      border: 1px solid #d2d6dc;
      border-radius: 0.375rem;
      padding: 0.5rem 0.75rem;
      outline: none;
    }
    .dataTables_wrapper .dataTables_paginate .paginate_button {
      font-size: inherit;
      line-height: inherit;
      color: inherit;
      font-family: inherit;
      background-color: #fff;
      border: 1px solid #d2d6dc;
      border-radius: 0.375rem;
      padding: 0.25rem 0.75rem;
      margin: 0 0.25rem;
      cursor: pointer;
    }
    .dataTables_wrapper .dataTables_paginate .paginate_button:hover {
      background-color: #f3f4f6;
    }
    .dataTables_wrapper .dataTables_paginate .paginate_button.current {
      background-color: #3b82f6;
      color: #fff !important;
      border-color: #3b82f6;
    }
    .dataTables_length select {
      -webkit-appearance: menulist;
      -moz-appearance: menulist;
      appearance: auto;
      background: none !important;
      background-image: none !important;
      font-size: inherit !important;
      line-height: inherit !important;
      text-align: center;
      text-align-last: center;
      -moz-text-align-last: center;
      padding-right: 2rem;
      border: 1px solid #d2d6dc;
      border-radius: 0.375rem;
      padding: 0.5rem 0.75rem;
      outline: none;
    }
    .dataTables_length label select {
      margin-right: 0.5rem;
    }
    .dataTables_wrapper .dataTables_info,
    .dataTables_wrapper .dataTables_paginate {
      display: flex !important;
      align-items: center !important;
      margin: 0 !important;
    }
    #logsTable {
      table-layout: fixed;
      width: 100%;
    }
    #logsTable th, 
    #logsTable td {
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
    }
  </style>
</head>
<body class="min-h-screen flex flex-col bg-white">
  <?php include "assets/nav.php"; ?>
  <main class="flex-grow pt-14">
    <div class="container mx-auto px-4 py-6">
      <!-- Card principal -->
      <div class="bg-white rounded-lg shadow px-4 py-5 sm:px-6">
        <!-- Cabecera -->
        <div class="sm:flex sm:items-center sm:justify-between">
          <div>
            <h1 class="text-lg font-medium text-gray-900">Logs</h1>
          </div>
        </div>
        <!-- Tabla con DataTables -->
        <div class="mt-6 overflow-x-auto">
          <table id="logsTable" class="table-auto w-full text-sm leading-tight">
            <thead>
              <tr>
                <th class="px-2 py-2">ID</th>
                <th class="px-2 py-2">Grupo</th>
                <th class="px-2 py-2">Tipo</th>
                <th class="px-2 py-2">ID Modif</th>
                <th class="px-2 py-2">Cambios</th>
                <th class="px-2 py-2">Usuario</th>
                <th class="px-2 py-2">Fecha</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($logs as $log): 
                // Convertir tipo numérico a texto
                $tipoText = ($log['tipo'] == 1) ? 'Alta' : (($log['tipo'] == 2) ? 'Modificación' : 'Eliminación');
                $usuario = trim($log['user_nombre'] . ' ' . $log['user_apellido']);
              ?>
              <tr class="hover:bg-gray-50">
                <td class="px-2 py-2"><?= htmlspecialchars($log['id']) ?></td>
                <td class="px-2 py-2"><?= htmlspecialchars($log['grupo']) ?></td>
                <td class="px-2 py-2"><?= htmlspecialchars($tipoText) ?></td>
                <td class="px-2 py-2"><?= htmlspecialchars($log['id_modif']) ?></td>
                <td class="px-2 py-2">
                  <!-- Usamos ENT_QUOTES para preservar el JSON -->
                  <button data-cambios="<?= htmlspecialchars($log['cambios'], ENT_QUOTES, 'UTF-8') ?>" class="ver-cambios bg-blue-600 text-white py-1 px-3 rounded hover:bg-blue-700">
                    Ver Cambios
                  </button>
                </td>
                <td class="px-2 py-2"><?= htmlspecialchars($usuario) ?></td>
                <td class="px-2 py-2"><?= htmlspecialchars($log['fecha']) ?></td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div><!-- /.overflow-x-auto -->
      </div><!-- /.bg-white rounded-lg shadow -->
    </div><!-- /.container -->
  </main>
  <?php include "assets/footer.php"; ?>
  
  <!-- Modal para mostrar cambios -->
  <div id="modalCambios" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden">
    <div class="bg-white rounded-lg shadow-lg w-11/12 md:w-1/2 p-6">
      <div class="flex justify-between items-center mb-4">
        <h2 class="text-xl font-bold">Detalles de Cambios</h2>
        <button id="cerrarModal" class="text-gray-600 hover:text-gray-800">&times;</button>
      </div>
      <div id="contenidoCambios" class="bg-gray-100 p-4 rounded overflow-auto text-sm"></div>
    </div>
  </div>
  
  <!-- jQuery y DataTables JS -->
  <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
  <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
  <script>
    $(document).ready(function() {
      // Inicializar DataTables
      var table = $('#logsTable').DataTable({
        dom: "<'flex items-center justify-between mb-4'l f>t<'flex items-center justify-between mt-4'i p>",
        buttons: [
          {
            extend: 'csvHtml5',
            text: 'Exportar CSV',
            exportOptions: { columns: ':not(.noExport)' }
          },
          {
            extend: 'excelHtml5',
            text: 'Exportar Excel',
            exportOptions: { columns: ':not(.noExport)' }
          }
        ],
        language: {
          "decimal": "",
          "emptyTable": "No hay información",
          "info": "Mostrando _START_ a _END_ de _TOTAL_ logs",
          "infoEmpty": "Mostrando 0 a 0 de 0 logs",
          "infoFiltered": "(Filtrado de _MAX_ logs en total)",
          "lengthMenu": "Mostrar _MENU_ logs",
          "loadingRecords": "Cargando...",
          "processing": "Procesando...",
          "search": "Buscar:",
          "zeroRecords": "No se encontraron logs",
          "paginate": {
            "first": "Primero",
            "last": "Último",
            "next": "Siguiente",
            "previous": "Anterior"
          }
        }
      });
      
      // Delegación de eventos para el botón "Ver Cambios"
      $('#logsTable tbody').on('click', '.ver-cambios', function() {
        var cambiosStr = $(this).attr('data-cambios');
        // Obtener el grupo (columna 2) desde la misma fila
        var grupo = $(this).closest('tr').find('td:nth-child(2)').text().trim();
        var output = "";
        
        try {
          var cambiosObj = JSON.parse(cambiosStr);
          
          // Definir traducciones para "Viaje"
          var translations = {
            "origin_id": "Lugar de Origen",
            "destination_id": "Lugar de Destino",
            "driver_id": "Chofer",
            "fecha_origen": "Fecha de Origen",
            "fecha_destino": "Fecha de Destino",
            "tipo_transporte": "Tipo de transporte",
            "km_recorridos": "KM Recorridos",
            "toneladas": "Toneladas",
            "tarifa_real": "Tarifa Real",
            "tarifa_rendida": "Tarifa Rendida",
            "estado_viaje": "Estado del Viaje",
            "estado_facturacion": "Estado de Facturación",
            "foto": "Foto",
            "comentario": "Comentario"
          };
          
          // Si el grupo es "Viaje", usamos traducciones; de lo contrario, usamos el nombre tal cual
          for (var key in cambiosObj) {
            if (cambiosObj.hasOwnProperty(key)) {
              var label = key;
              if (grupo.toLowerCase() === "viaje" && translations.hasOwnProperty(key)) {
                label = translations[key];
              }
              
              var valor = cambiosObj[key];
              
              // Caso típico: { "old": "...", "new": "..." }
              if (
                valor &&
                typeof valor === 'object' &&
                valor.hasOwnProperty('old') &&
                valor.hasOwnProperty('new')
              ) {
                output += "<p><strong>" + label + ":</strong> de " + valor.old + " a " + valor.new + "</p>";
              } else {
                // Mostrarlo como "label: valor" (si es objeto se JSON.stringify)
                if (typeof valor === 'object') {
                  valor = JSON.stringify(valor);
                }
                output += "<p><strong>" + label + ":</strong> " + valor + "</p>";
              }
            }
          }
        } catch(e) {
          // Si hay error parseando, simplemente lo mostramos tal cual
          output = "<p>" + cambiosStr + "</p>";
        }
        
        $('#contenidoCambios').html(output);
        $('#modalCambios').removeClass('hidden');
      });
      
      // Cerrar modal
      $('#cerrarModal').on('click', function() {
        $('#modalCambios').addClass('hidden');
      });
    });
  </script>
</body>
</html>
