<?php
/**
 * public/login_process.php
 */
session_start();
require_once "../config/db.php";
require_once "../helpers/functions.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    // Buscamos el usuario
    $sql = "SELECT * FROM users WHERE username = :username LIMIT 1";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['username' => $username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        // Verificamos el password (asume que en BD está password_hash)
        if (password_verify($password, $user['password'])) {
            // Autenticación exitosa
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];

            redirect('trips/');
        } else {
            // Password incorrecto
            redirect('login.php?error=1');
        }
    } else {
        // Usuario no encontrado
        redirect('login.php?error=2');
    }
} else {
    // Acceso directo sin POST
    redirect('login.php');
}
