<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <!-- Para que se muestre correctamente en móviles -->
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login - Gestión de Camiones</title>
  <!-- Carga de Tailwind por CDN -->
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    .logo {
      width: 200px;
      margin: auto;
    }
  </style>
</head>
<body class="bg-gray-900 min-h-screen flex items-center justify-center">
  <!-- Contenedor principal del formulario -->
  <div class="w-full max-w-md p-8 m-auto bg-gray-800 rounded-md shadow-md">
    <h1 class="text-2xl font-bold text-center text-white mb-8">
      <img src="assets/img/logo.png" class="logo" alt="">
    </h1>
    <form action="login_process.php" method="POST" class="space-y-6">
      <div>
        <input 
          placeholder="Usuario"
          type="text" 
          id="username" 
          name="username" 
          class="block w-full rounded-md bg-gray-900 px-4 py-3 text-base text-gray-300 
                 border border-gray-700 placeholder:text-gray-500 
                 focus:ring-blue-500 focus:border-blue-500"
          required 
        />
      </div>
      <div>
        <input 
          placeholder="Contraseña"
          type="password" 
          id="password" 
          name="password" 
          class="block w-full rounded-md bg-gray-900 px-4 py-3 text-base text-gray-300 
                 border border-gray-700 placeholder:text-gray-500 
                 focus:ring-blue-500 focus:border-blue-500"
          required 
        />
      </div>
      <button 
        type="submit" 
        class="w-full py-3 rounded bg-blue-500 text-white 
               hover:bg-blue-400 focus:outline-none focus:ring-2 
               focus:ring-blue-500 focus:ring-offset-2 text-base">
        Entrar
      </button>
    </form>
  </div>
</body>
</html>
