<?php
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

/* --- Entrada segura --- */
$vehicle_id = isset($_GET['vehicle_id']) ? (int)$_GET['vehicle_id'] : 0;
if ($vehicle_id <= 0) { header('Location: index.php'); exit; }

/* Traer la patente (y validar que exista) */
$stV = $pdo->prepare("SELECT id, patente FROM vehicles WHERE id = ?");
$stV->execute([$vehicle_id]);
$veh = $stV->fetch(PDO::FETCH_ASSOC);
if (!$veh) { header('Location: index.php'); exit; }

/* Cargas de combustible de la patente */
$sql = "
  SELECT fl.id, fl.fecha, fl.litros, fl.importe, fl.lugar, fl.tipo,
         fl.odometro_km, fl.observaciones, fl.archivo,
         fp.nombre AS proveedor
  FROM fuel_loads fl
  LEFT JOIN fuel_providers fp ON fp.id = fl.provider_id
  WHERE fl.vehicle_id = ?
  ORDER BY fl.fecha DESC, fl.id DESC
";
$st = $pdo->prepare($sql);
$st->execute([$vehicle_id]);
$rows = $st->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Cargas – <?= htmlspecialchars($veh['patente']) ?></title>

  <!-- Bootstrap + Icons + DataTables -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">

  <style>
    body{ background:#f6f7f8; font-family:"Segoe UI", Arial, sans-serif; }
    .content-wrap { margin-top:82px; padding-bottom:40px; }
    table.dataTable td { vertical-align: middle; }
    /* Paginación igual a otras páginas */
    .dataTables_wrapper .dataTables_paginate ul.pagination .page-item .page-link {
      background-color:#000 !important; color:#fff !important; border:1px solid #000 !important;
      border-radius:4px !important; margin:0 2px !important; padding:6px 12px !important; line-height:1.2 !important;
    }
    .dataTables_wrapper .dataTables_paginate ul.pagination .page-item .page-link:hover {
      filter:brightness(1.25); color:#fff !important; text-decoration:none !important;
    }
    .dataTables_wrapper .dataTables_paginate ul.pagination .page-item.active .page-link {
      background-color:#f68b1e !important; border-color:#f68b1e !important; color:#fff !important;
    }
    .dataTables_wrapper .dataTables_paginate ul.pagination .page-item.disabled .page-link {
      background-color:#000 !important; color:#bbb !important; opacity:.6; cursor:not-allowed;
    }
  </style>
</head>
<body>
  <?php include "../assets/nav2.php"; ?>

  <div class="content-wrap container">
    <div class="card shadow-sm">
      <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0 text-primary fw-bold">Cargas – <?= htmlspecialchars($veh['patente']) ?></h5>
        <a href="index.php" class="btn btn-dark btn-sm"><i class="bi bi-arrow-left"></i> Volver</a>
      </div>

      <div class="card-body">
        <div class="table-responsive">
          <table id="loadsTable" class="table table-striped table-hover align-middle">
            <thead class="table-light">
              <tr>
                <th>Fecha</th>
                <th>Proveedor</th>
                <th>Litros</th>
                
                <th>Odómetro</th>
                <th>Lugar</th>
               
                <th>Observaciones</th>
                <th>Adjunto</th>
                <th class="text-center">Acciones</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($rows as $r): ?>
                <tr>
                  <td><?= htmlspecialchars($r['fecha']) ?></td>
                  <td><?= htmlspecialchars($r['proveedor'] ?? '—') ?></td>
                  <td><?= number_format((float)$r['litros'], 2, ',', '.') ?></td>
                  
                  <td><?= $r['odometro_km'] !== null ? (int)$r['odometro_km'] : '—' ?></td>
                  <td><?= htmlspecialchars($r['lugar'] ?? '') ?></td>
                 
                  <td><?= htmlspecialchars($r['observaciones'] ?? '') ?></td>
                  <td class="text-center">
                    <?php if (!empty($r['archivo'])): ?>
                      <a class="btn btn-outline-primary btn-sm"
                         href="<?= htmlspecialchars($r['archivo']) ?>" target="_blank" title="Ver archivo">
                        <i class="bi bi-paperclip"></i> Ver
                      </a>
                    <?php else: ?>
                      —
                    <?php endif; ?>
                  </td>
                  <td class="text-center">
                    <div class="d-flex justify-content-center gap-2">
                      <a href="load_edit.php?id=<?= (int)$r['id'] ?>&vehicle_id=<?= $vehicle_id ?>"
                         class="btn btn-primary btn-sm text-white" title="Editar">
                        <i class="bi bi-pencil"></i>
                      </a>
                      <a href="load_delete.php?id=<?= (int)$r['id'] ?>&vehicle_id=<?= $vehicle_id ?>"
                         class="btn btn-danger btn-sm text-white" title="Eliminar"
                         onclick="return confirm('¿Seguro querés eliminar esta carga?');">
                        <i class="bi bi-trash"></i>
                      </a>
                    </div>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>

  <?php include "../assets/footer.php"; ?>

  <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
  <script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
  <script>
    $(function(){
      $('#loadsTable').DataTable({
        language: {
          emptyTable: "Sin cargas registradas",
          info: "Mostrando _START_ a _END_ de _TOTAL_ cargas",
          infoEmpty: "Mostrando 0 a 0 de 0 cargas",
          infoFiltered: "(filtrado de _MAX_ cargas)",
          lengthMenu: "Mostrar _MENU_",
          search: "Buscar:",
          zeroRecords: "No se encontraron cargas",
          paginate: { first:"Primero", last:"Último", next:"Siguiente", previous:"Anterior" }
        },
        pageLength: 25,
        lengthMenu: [10,25,50,100]
      });
    });
  </script>
</body>
</html>