<?php
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

/* ====== Util ====== */
function onlyChassis(PDO $pdo) {
  $sql = "
    SELECT id, patente
    FROM vehicles
    WHERE patente IN ('AD763LR','AF711ZM','AG768HO','PQR160')
    ORDER BY FIELD(patente,'AD763LR','AF711ZM','AG768HO','PQR160')";
  return $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
}
function allProviders(PDO $pdo) {
  return $pdo->query("SELECT id, nombre FROM fuel_providers ORDER BY nombre")->fetchAll(PDO::FETCH_ASSOC);
}

/* ====== Carga a editar ====== */
$id = (int)($_GET['id'] ?? 0);
$st = $pdo->prepare("
  SELECT fl.*, v.patente, fp.nombre AS proveedor
  FROM fuel_loads fl
  JOIN vehicles v      ON v.id  = fl.vehicle_id
  LEFT JOIN fuel_providers fp ON fp.id = fl.provider_id
  WHERE fl.id = ?");
$st->execute([$id]);
$row = $st->fetch(PDO::FETCH_ASSOC);
if (!$row) { header('Location: index.php'); exit; }

$vehicles  = onlyChassis($pdo);
$providers = allProviders($pdo);

/* ====== POST: actualizar (SIN importe y SIN tipo) ====== */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $vehicle_id   = (int)($_POST['vehicle_id'] ?? $row['vehicle_id']);
  $fecha        = $_POST['fecha'] ?? $row['fecha'];
  $litros       = (float)($_POST['litros'] ?? $row['litros']);
  $odometro_km  = ($_POST['odometro_km'] !== '' ? (int)$_POST['odometro_km'] : null);
  $lugar        = trim($_POST['lugar'] ?? '');
  $observaciones= trim($_POST['observaciones'] ?? '');

  // Proveedor (existente o nuevo)
  $provider_id = null;
  if (!empty($_POST['provider_id']) && $_POST['provider_id'] !== '__otro__') {
    $provider_id = (int)$_POST['provider_id'];
  }
  $provider_name = trim($_POST['provider_name'] ?? '');
  if ($provider_name !== '') {
    $chk = $pdo->prepare("SELECT id FROM fuel_providers WHERE nombre = ?");
    $chk->execute([$provider_name]);
    $pid = $chk->fetchColumn();
    if ($pid) {
      $provider_id = (int)$pid;
    } else {
      $ins = $pdo->prepare("INSERT INTO fuel_providers (nombre, precio_actual) VALUES (?, NULL)");
      $ins->execute([$provider_name]);
      $provider_id = (int)$pdo->lastInsertId();
    }
  }

  // Adjuntos: eliminar / reemplazar / mantener
  $archivoPath = $row['archivo'];
  if (!empty($_POST['remove_file'])) {
    // eliminar archivo existente del disco (si está dentro de /app/public/uploads/fuel)
    if ($archivoPath && str_starts_with($archivoPath, '/app/public/uploads/fuel/')) {
      $abs = realpath(__DIR__ . '/../..' . $archivoPath); // /app/public/... -> relativo a /app/public/fuel
      if ($abs && file_exists($abs)) @unlink($abs);
    }
    $archivoPath = null;
  }
  if (!empty($_FILES['archivo']['name']) && $_FILES['archivo']['error'] === UPLOAD_ERR_OK) {
    // si había uno previo y no lo marcó para eliminar, lo reemplazamos igualmente
    if ($archivoPath && str_starts_with($archivoPath, '/app/public/uploads/fuel/')) {
      $absPrev = realpath(__DIR__ . '/../..' . $archivoPath);
      if ($absPrev && file_exists($absPrev)) @unlink($absPrev);
    }
    $allowed = ['jpg','jpeg','png','webp','pdf'];
    $orig    = $_FILES['archivo']['name'];
    $ext     = strtolower(pathinfo($orig, PATHINFO_EXTENSION));
    if (in_array($ext, $allowed, true)) {
      $base  = preg_replace('/[^a-zA-Z0-9_\-\.]/','_', pathinfo($orig, PATHINFO_FILENAME));
      $fname = date('Ymd_His').'_'.($_SESSION['user_id'] ?? 'u').'_'.$base.'.'.$ext;
      $destDir = __DIR__ . '/../uploads/fuel';
      if (!is_dir($destDir)) { @mkdir($destDir, 0755, true); }
      $destAbs = $destDir . DIRECTORY_SEPARATOR . $fname;
      if (move_uploaded_file($_FILES['archivo']['tmp_name'], $destAbs)) {
        $archivoPath = '/app/public/uploads/fuel/'.$fname;
      }
    }
  }

  // UPDATE (sin columnas importe, tipo)
  $up = $pdo->prepare("
    UPDATE fuel_loads
       SET vehicle_id    = :vehicle_id,
           provider_id   = :provider_id,
           fecha         = :fecha,
           litros        = :litros,
           odometro_km   = :odometro_km,
           lugar         = :lugar,
           observaciones = :observaciones,
           archivo       = :archivo
     WHERE id = :id");
  $up->execute([
    ':vehicle_id'   => $vehicle_id,
    ':provider_id'  => $provider_id ?: null,
    ':fecha'        => $fecha,
    ':litros'       => $litros,
    ':odometro_km'  => $odometro_km,
    ':lugar'        => $lugar,
    ':observaciones'=> $observaciones,
    ':archivo'      => $archivoPath,
    ':id'           => $id,
  ]);

  // volver al listado de esa patente
  header("Location: loads.php?vehicle_id=".$vehicle_id);
  exit;
}

/* ====== UI ====== */
ob_start(); include '../assets/nav2.php'; $navHtml = ob_get_clean();
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Editar carga - Combustible</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
  <style>
    .content-wrap { margin-top: 82px; padding-bottom: 40px; }
    body { background:#f6f7f8; font-family:"Segoe UI", Arial, sans-serif; font-size:14px; color:#222; }
    .page-card { border-radius:8px; border:1px solid #e6e9ec; background:#fff; }
  </style>
</head>
<body>
<?= $navHtml ?>

<div class="content-wrap container">
  <div class="page-card card">
    <div class="card-header bg-white d-flex justify-content-between align-items-center">
      <h5 class="mb-0 text-primary fw-bold">Editar carga</h5>
      <a href="loads.php?vehicle_id=<?= (int)$row['vehicle_id'] ?>" class="btn btn-dark btn-sm">Volver</a>
    </div>

    <div class="card-body">
      <form method="post" enctype="multipart/form-data" class="row g-3">

        <div class="col-md-2">
          <label class="form-label">Patente</label>
          <select name="vehicle_id" class="form-select" required>
            <?php foreach ($vehicles as $v): ?>
              <option value="<?= $v['id'] ?>" <?= $v['id']==$row['vehicle_id']?'selected':'' ?>>
                <?= htmlspecialchars($v['patente']) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="col-md-2">
          <label class="form-label">Fecha</label>
          <input type="date" name="fecha" class="form-control" value="<?= htmlspecialchars($row['fecha']) ?>" required>
        </div>

        <div class="col-md-2">
          <label class="form-label">Proveedor</label>
          <select name="provider_id" id="provider_id" class="form-select">
            <option value="">— Seleccionar —</option>
            <?php foreach ($providers as $p): ?>
              <option value="<?= $p['id'] ?>" <?= ($row['provider_id']==$p['id'])?'selected':'' ?>>
                <?= htmlspecialchars($p['nombre']) ?>
              </option>
            <?php endforeach; ?>
            <option value="__otro__">— Escribir otro… —</option>
          </select>
        </div>

        <div class="col-md-2">
          <label class="form-label">Nuevo proveedor</label>
          <input type="text" name="provider_name" id="provider_name"
                 class="form-control" placeholder="Nombre proveedor" disabled>
        </div>

        <div class="col-md-2">
          <label class="form-label">Litros</label>
          <input type="number" step="0.001" name="litros" class="form-control"
                 value="<?= htmlspecialchars($row['litros']) ?>" required>
        </div>

        <div class="col-md-2">
          <label class="form-label">Odómetro (km)</label>
          <input type="number" name="odometro_km" class="form-control"
                 value="<?= htmlspecialchars($row['odometro_km']) ?>">
        </div>

        <div class="col-md-3">
          <label class="form-label">Lugar</label>
          <input type="text" name="lugar" class="form-control" value="<?= htmlspecialchars($row['lugar']) ?>">
        </div>

        <div class="col-md-5">
          <label class="form-label">Observaciones</label>
          <input type="text" name="observaciones" class="form-control"
                 value="<?= htmlspecialchars($row['observaciones']) ?>">
        </div>

        <div class="col-md-4">
          <label class="form-label">Adjunto (jpg/png/webp/pdf)</label>
          <div class="d-flex align-items-center gap-2 mb-2">
            <?php if (!empty($row['archivo'])): ?>
              <a class="btn btn-outline-primary btn-sm" href="<?= htmlspecialchars($row['archivo']) ?>" target="_blank">
                <i class="bi bi-paperclip"></i> Ver actual
              </a>
              <div class="form-check">
                <input class="form-check-input" type="checkbox" name="remove_file" id="remove_file" value="1">
                <label class="form-check-label" for="remove_file">Eliminar archivo</label>
              </div>
            <?php else: ?>
              <span class="text-muted">— Sin archivo —</span>
            <?php endif; ?>
          </div>
          <input type="file" name="archivo" class="form-control" accept=".jpg,.jpeg,.png,.webp,.pdf">
          <div class="form-text">Si adjuntás un archivo nuevo, reemplaza al anterior.</div>
        </div>

        <div class="col-12 d-flex gap-2">
          <button class="btn btn-primary">Guardar cambios</button>
          <a href="loads.php?vehicle_id=<?= (int)$row['vehicle_id'] ?>" class="btn btn-secondary">Cancelar</a>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
(function(){
  const sel = document.getElementById('provider_id');
  const txt = document.getElementById('provider_name');
  if (!sel || !txt) return;
  function toggle(){
    if (sel.value === '__otro__') {
      txt.disabled = false; txt.required = true; txt.focus();
    } else {
      txt.value=''; txt.disabled = true; txt.required = false;
    }
  }
  sel.addEventListener('change', toggle);
  toggle();
})();
</script>
</body>
</html>