<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'];
    $nombre = $_POST['nombre'];
    $apellido = $_POST['apellido'];
    $telefono = $_POST['telefono'];
    $fecha_inicio = $_POST['fecha_inicio'];
    
    // 1) Obtener los datos antiguos para comparar
    $stmtOld = $pdo->prepare("SELECT nombre, apellido, telefono, fecha_inicio FROM drivers WHERE id = :id");
    $stmtOld->execute(['id' => $id]);
    $oldData = $stmtOld->fetch(PDO::FETCH_ASSOC);
    
    // 2) Actualizar en la BD
    $stmt = $pdo->prepare("UPDATE drivers SET nombre = :nombre, apellido = :apellido, telefono = :telefono, fecha_inicio = :fecha_inicio, updated_at = NOW() WHERE id = :id");
    $stmt->execute([
        'nombre'      => $nombre,
        'apellido'    => $apellido,
        'telefono'    => $telefono,
        'fecha_inicio'=> $fecha_inicio,
        'id'          => $id
    ]);
    
    // 3) Comparar valores para registrar las diferencias
    $nuevosDatos = [
        'nombre'      => $nombre,
        'apellido'    => $apellido,
        'telefono'    => $telefono,
        'fecha_inicio'=> $fecha_inicio
    ];
    
    $diff = [];
    foreach ($nuevosDatos as $campo => $nuevoValor) {
        if (isset($oldData[$campo]) && $oldData[$campo] != $nuevoValor) {
            $diff[$campo] = [
                'old' => $oldData[$campo],
                'new' => $nuevoValor
            ];
        }
    }
    $cambios = json_encode($diff);
    
    // 4) Insertar en logs la actualización (tipo 2)
    $log_sql = "INSERT INTO logs (grupo, tipo, id_modif, user, cambios, fecha) 
                VALUES ('Chofer', 2, :driver_id, :user, :cambios, NOW())";
    $log_stmt = $pdo->prepare($log_sql);
    $log_stmt->execute([
        'driver_id' => $id,
        'user'      => $_SESSION['user_id'] ?? 0,
        'cambios'   => $cambios
    ]);
    
    header('Location: index.php');
    exit;
}
?>
