<?php
session_start();
require_once '../../config/db.php';

// Establece el Content-Type a JSON
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Recoger datos del formulario
        $nombre       = $_POST['nombre'] ?? '';
        $apellido     = $_POST['apellido'] ?? '';
        $telefono     = $_POST['telefono'] ?? '';
        $fecha_inicio = $_POST['fecha_inicio'] ?? '';

        // 1) Insertar el nuevo chofer en la tabla drivers
        $stmt = $pdo->prepare("INSERT INTO drivers (nombre, apellido, telefono, fecha_inicio, estado) VALUES (:nombre, :apellido, :telefono, :fecha_inicio, :estado)");
        $stmt->execute([
            'nombre'       => $nombre,
            'apellido'     => $apellido,
            'telefono'     => $telefono,
            'fecha_inicio' => $fecha_inicio,
            'estado'       => 0
        ]);

        // Obtener el ID del chofer insertado
        $driver_id = $pdo->lastInsertId();

        // 2) Construir los datos para el log
        $cambios = json_encode([
            'nombre'       => $nombre,
            'apellido'     => $apellido,
            'telefono'     => $telefono,
            'fecha_inicio' => $fecha_inicio,
            'estado'       => 0
        ]);

        // 3) Insertar en logs la creación (tipo 1)
        $log_sql = "INSERT INTO logs (grupo, tipo, id_modif, user, cambios, fecha) VALUES ('Chofer', 1, :driver_id, :user, :cambios, NOW())";
        $log_stmt = $pdo->prepare($log_sql);
        $log_stmt->execute([
            'driver_id' => $driver_id,
            'user'      => $_SESSION['user_id'] ?? 0,
            'cambios'   => $cambios
        ]);

        // 4) Retornar la respuesta JSON con los datos del nuevo chofer
        echo json_encode([
            'success' => true,
            'data'    => [
                'id'          => $driver_id,
                'nombre'      => $nombre,
                'apellido'    => $apellido,
                'telefono'    => $telefono,
                'fecha_inicio'=> $fecha_inicio,
                'estado'      => 0
            ]
        ]);
        exit;
    } catch (Exception $e) {
        // En caso de error, retornar el error en JSON
        echo json_encode([
            'success' => false,
            'error'   => $e->getMessage()
        ]);
        exit;
    }
} else {
    echo json_encode([
        'success' => false,
        'error'   => 'Método no permitido'
    ]);
    exit;
}
