<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nombre       = $_POST['nombre']       ?? '';
    $apellido     = $_POST['apellido']     ?? '';
    $telefono     = $_POST['telefono']     ?? '';
    $fecha_inicio = $_POST['fecha_inicio'] ?? null;

    // 1) Insertar el nuevo chofer en la tabla drivers (siempre con estado = 1)
    $stmt = $pdo->prepare("
        INSERT INTO drivers (nombre, apellido, telefono, fecha_inicio, estado)
        VALUES (:nombre, :apellido, :telefono, :fecha_inicio, 1)
    ");
    $stmt->execute([
        'nombre'       => $nombre,
        'apellido'     => $apellido,
        'telefono'     => $telefono,
        'fecha_inicio' => $fecha_inicio,
    ]);

    // Obtener el ID del chofer insertado
    $driver_id = $pdo->lastInsertId();

    // 2) Construir el JSON con los datos insertados (estado = 1 porque está activo)
    $cambios = json_encode([
        'nombre'       => $nombre,
        'apellido'     => $apellido,
        'telefono'     => $telefono,
        'fecha_inicio' => $fecha_inicio,
        'estado'       => 1
    ]);

    // 3) Insertar en logs la creación (tipo 1)
    $log_sql = "
        INSERT INTO logs (grupo, tipo, id_modif, user, cambios, fecha)
        VALUES ('Chofer', 1, :driver_id, :user, :cambios, NOW())
    ";
    $log_stmt = $pdo->prepare($log_sql);
    $log_stmt->execute([
        'driver_id' => $driver_id,
        'user'      => $_SESSION['user_id'] ?? 0,
        'cambios'   => $cambios
    ]);

    header('Location: index.php');
    exit;
}
?>