<?php
// public/drivers/delete.php
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$action = $_GET['action'] ?? 'delete'; // delete | restore

if ($id <= 0) {
    $_SESSION['error'] = "ID inválido.";
    header('Location: index.php');
    exit;
}

try {
    if ($action === 'restore') {
        // Reactivar chofer
        $stmt = $pdo->prepare("
            UPDATE drivers 
            SET estado = 1, updated_at = NOW()
            WHERE id = :id
        ");
        $stmt->execute(['id' => $id]);
        $_SESSION['success'] = "Chofer reactivado correctamente.";
    } else {
        // Borrado lógico: marcamos estado = 0
        $stmt = $pdo->prepare("
            UPDATE drivers 
            SET estado = 0, updated_at = NOW()
            WHERE id = :id
        ");
        $stmt->execute(['id' => $id]);
        $_SESSION['success'] = "Chofer desactivado correctamente.";
    }
} catch (Throwable $e) {
    $_SESSION['error'] = "No se pudo actualizar el estado del chofer. " . $e->getMessage();
}

header('Location: index.php');
exit;