<?php
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();
?>
<!DOCTYPE html>
<html lang="es" class="h-full bg-white">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Agregar Chofer - Macher</title>

  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Bootstrap Icons -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

  <style>
    body {
      background-color: #f8f9fa;
      font-family: "Inter", sans-serif;
    }
    .content-wrap { 
      margin-top: 82px; 
      padding-bottom: 40px; 
    }
    /* Forzar visibilidad del menú móvil */
    .navbar .collapse { 
      visibility: visible !important; 
    }
    /* Botones */
    .btn { transition: filter .15s ease; }
    .btn:hover { filter: brightness(0.9); }
    .btn i { font-size: 1rem; }
  </style>
</head>
<body class="h-full bg-white flex flex-col">
  <?php include "../assets/nav2.php"; ?>

  <main class="content-wrap container">
    <div class="card shadow-sm">
      <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0 text-primary fw-bold">
          <i class="bi bi-person-plus-fill me-2"></i>Agregar Nuevo Chofer
        </h5>
      </div>

      <div class="card-body">
        <p class="text-muted mb-4">Complete los datos del chofer a registrar:</p>

        <form action="store.php" method="POST" class="row g-3">
          <!-- Nombre -->
          <div class="col-md-6">
            <label for="nombre" class="form-label fw-semibold">Nombre</label>
            <input type="text" id="nombre" name="nombre" required class="form-control">
          </div>
          <!-- Apellido -->
          <div class="col-md-6">
            <label for="apellido" class="form-label fw-semibold">Apellido</label>
            <input type="text" id="apellido" name="apellido" required class="form-control">
          </div>
          <!-- Teléfono -->
          <div class="col-md-6">
            <label for="telefono" class="form-label fw-semibold">Teléfono</label>
            <input type="text" id="telefono" name="telefono" required class="form-control">
          </div>
          <!-- Fecha de inicio -->
          <div class="col-md-6">
            <label for="fecha_inicio" class="form-label fw-semibold">Fecha de Inicio</label>
            <input type="date" id="fecha_inicio" name="fecha_inicio" required class="form-control">
          </div>

          <!-- Botones -->
          <div class="col-12 d-flex justify-content-center mt-4 gap-3">
            <a href="index.php" class="btn btn-dark text-white px-4">
              <i class="bi bi-arrow-left"></i> Volver
            </a>
            <button type="submit" class="btn btn-primary text-white px-4">
              <i class="bi bi-save"></i> Guardar
            </button>
          </div>
        </form>
      </div>
    </div>
  </main>

  <?php include "../assets/footer.php"; ?>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>