<?php
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

/* ===== Entradas ===== */
$driver_id = (int)($_GET['id'] ?? 0);
$mes  = $_GET['mes']  ?? date('m');
$anio = $_GET['anio'] ?? date('Y');

$periodo_inicio = "$anio-$mes-01";
$periodo_fin = date('Y-m-d', strtotime("$periodo_inicio +1 month"));

/* ===== Chofer ===== */
$st = $pdo->prepare("SELECT nombre, apellido FROM drivers WHERE id = ?");
$st->execute([$driver_id]);
$driver = $st->fetch(PDO::FETCH_ASSOC);
if (!$driver) die('Chofer no encontrado');

/* ===== Saldo anterior ===== */
$st = $pdo->prepare("
  SELECT COALESCE(SUM(haber),0) - COALESCE(SUM(debe),0)
  FROM driver_movements
  WHERE driver_id = ? AND estado = 1 AND fecha < ?
");
$st->execute([$driver_id, $periodo_inicio]);
$saldo_anterior = (float)$st->fetchColumn();

/* ===== Movimientos del mes ===== */
$st = $pdo->prepare("
  SELECT *
  FROM driver_movements
  WHERE driver_id = ? AND estado = 1
    AND fecha >= ? AND fecha < ?
  ORDER BY fecha
");
$st->execute([$driver_id, $periodo_inicio, $periodo_fin]);
$movs = $st->fetchAll(PDO::FETCH_ASSOC);

$tot_debe = $tot_haber = 0;
foreach ($movs as $m) {
  $tot_debe  += (float)$m['debe'];
  $tot_haber += (float)$m['haber'];
}

/* ===== Viajes ===== */
$st = $pdo->prepare("
  SELECT *
  FROM trips
  WHERE driver_id = ?
    AND estado_viaje = 'Realizado'
    AND (
      (fecha_destino IS NOT NULL AND fecha_destino >= ? AND fecha_destino < ?)
      OR
      (fecha_destino IS NULL AND fecha_origen >= ? AND fecha_origen < ?)
    )
  ORDER BY COALESCE(fecha_destino, fecha_origen)
");
$st->execute([$driver_id, $periodo_inicio, $periodo_fin, $periodo_inicio, $periodo_fin]);
$viajes = $st->fetchAll(PDO::FETCH_ASSOC);

$tot_16 = 0;
foreach ($viajes as $v) {
  $base = ((float)$v['toneladas']) * ((float)$v['tarifa_rendida']);
  $tot_16 += $base * 0.16;
}

$saldo_final = $saldo_anterior + $tot_16 + ($tot_haber - $tot_debe);
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Liquidación <?= "$mes/$anio" ?> - <?= htmlspecialchars($driver['apellido']) ?></title>

<style>
body { font-family: Arial, sans-serif; font-size: 12px; color:#111; }
h1,h2 { margin: 0 0 6px 0; }

table { width:100%; border-collapse: collapse; margin-bottom: 12px; }
th, td { border:1px solid #ccc; padding:4px 6px; }
th { background:#f0f0f0; }

.text-end { text-align:right; }
.no-print { margin-bottom:12px; }

@media print {
  @page { size: A4 landscape; margin: 8mm; }
  .no-print { display:none; }
}
</style>
</head>

<body>

<div class="no-print">
  <button onclick="window.print()">🖨️ Imprimir / Guardar PDF</button>
</div>

<h1>Liquidación de Chofer</h1>
<h2><?= htmlspecialchars($driver['nombre'].' '.$driver['apellido']) ?> — <?= "$mes/$anio" ?></h2>

<hr>

<h3>Viajes realizados</h3>
<table>
<thead>
<tr>
  <th>Fecha</th>
  <th>Resumen</th>
  <th class="text-end">Tn</th>
  <th class="text-end">Tarifa</th>
  <th class="text-end">Base</th>
  <th class="text-end">16%</th>
</tr>
</thead>
<tbody>
<?php foreach ($viajes as $v):
  $tn = (float)$v['toneladas'];
  $tar = (float)$v['tarifa_rendida'];
  $base = $tn * $tar;
  $liq = $base * 0.16;
?>
<tr>
  <td><?= $v['fecha_destino'] ?? $v['fecha_origen'] ?></td>
  <td><?= htmlspecialchars($v['linea_factura'] ?: 'Viaje #'.$v['id']) ?></td>
  <td class="text-end"><?= number_format($tn,2,',','.') ?></td>
  <td class="text-end">$ <?= number_format($tar,2,',','.') ?></td>
  <td class="text-end">$ <?= number_format($base,2,',','.') ?></td>
  <td class="text-end">$ <?= number_format($liq,2,',','.') ?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>

<h3>Movimientos</h3>
<table>
<thead>
<tr>
  <th>Fecha</th>
  <th>Tipo</th>
  <th>Descripción</th>
  <th class="text-end">Debe</th>
  <th class="text-end">Haber</th>
</tr>
</thead>
<tbody>
<?php foreach ($movs as $m): ?>
<tr>
  <td><?= $m['fecha'] ?></td>
  <td><?= htmlspecialchars($m['tipo']) ?></td>
  <td><?= htmlspecialchars($m['descripcion']) ?></td>
  <td class="text-end">$ <?= number_format($m['debe'],2,',','.') ?></td>
  <td class="text-end">$ <?= number_format($m['haber'],2,',','.') ?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>

<h3>Resumen final</h3>
<table>
<tr><th>Total 16%</th><td class="text-end">$ <?= number_format($tot_16,2,',','.') ?></td></tr>
<tr><th>Saldo anterior</th><td class="text-end">$ <?= number_format($saldo_anterior,2,',','.') ?></td></tr>
<tr><th>Movimientos</th><td class="text-end">$ <?= number_format($tot_haber-$tot_debe,2,',','.') ?></td></tr>
<tr><th><strong>Saldo a cobrar</strong></th><td class="text-end"><strong>$ <?= number_format($saldo_final,2,',','.') ?></strong></td></tr>
</table>

</body>
</html>