<?php
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

// ---- Entrada ----
$driver_id = isset($_POST['driver_id']) ? (int)$_POST['driver_id'] : 0;
$mes       = isset($_POST['mes']) ? (int)$_POST['mes'] : (int)date('n');
$anio      = isset($_POST['anio']) ? (int)$_POST['anio'] : (int)date('Y');

if ($driver_id <= 0) {
    $_SESSION['error'] = 'Chofer no válido para importar viajes.';
    header('Location: index.php');
    exit;
}

// Normalizar mes/año
if ($mes < 1 || $mes > 12) { $mes = (int)date('n'); }
if ($anio < 2020 || $anio > 2100) { $anio = (int)date('Y'); }

$mesStr      = str_pad($mes, 2, '0', STR_PAD_LEFT);
$fechaDesde  = "$anio-$mesStr-01";
$fechaHasta  = date('Y-m-t', strtotime($fechaDesde)); // último día del mes
$userId      = $_SESSION['user_id'] ?? 0;

// ---- Buscar viajes del chofer en ese mes ----
$sqlViajes = "
  SELECT id, fecha_destino, tarifa_rendida, toneladas, linea_factura
  FROM trips
  WHERE driver_id = :driver_id
    AND estado_viaje = 'Realizado'
    AND fecha_destino IS NOT NULL
    AND fecha_destino >= :desde
    AND fecha_destino <= :hasta
";
$stmtV = $pdo->prepare($sqlViajes);
$stmtV->execute([
    'driver_id' => $driver_id,
    'desde'     => $fechaDesde,
    'hasta'     => $fechaHasta,
]);
$viajes = $stmtV->fetchAll(PDO::FETCH_ASSOC);

$insertados = 0;

foreach ($viajes as $v) {
    $tripId  = (int)$v['id'];

    // 1) Evitar duplicados: si ya hay movimiento con ese trip_id, lo saltamos
    $stmtChk = $pdo->prepare("
        SELECT id
        FROM driver_movements
        WHERE driver_id = :driver_id
          AND trip_id   = :trip_id
          AND estado    = 1
        LIMIT 1
    ");
    $stmtChk->execute([
        'driver_id' => $driver_id,
        'trip_id'   => $tripId,
    ]);
    if ($stmtChk->fetch()) {
        continue; // ya existe, no lo volvemos a cargar
    }

    // 2) Calcular monto del chofer: 16% de (tarifa_rendida * toneladas)
    $tarifa   = (float)($v['tarifa_rendida'] ?? 0);
    $toneladas= (float)($v['toneladas'] ?? 0);

    if ($tarifa <= 0 || $toneladas <= 0) {
        // Si faltan datos coherentes, no insertamos nada
        continue;
    }

    $montoChofer = round($tarifa * $toneladas * 0.16, 2);

    // 3) Descripción
    $descripcion = $v['linea_factura'] ?: ('Viaje ID ' . $tripId);
    $fecha       = $v['fecha_destino'] ?: $fechaDesde;

    // 4) Insertar movimiento en driver_movements
    $sqlIns = "
      INSERT INTO driver_movements
        (driver_id, fecha, tipo, descripcion, medio_pago, debe, haber, trip_id, origen, user_id, estado, created_at)
      VALUES
        (:driver_id, :fecha, 'viaje_auto', :descripcion, 'a liquidar', 0, :haber, :trip_id, 'import_trips', :user_id, 1, NOW())
    ";
    $stmtIns = $pdo->prepare($sqlIns);
    $stmtIns->execute([
        'driver_id'   => $driver_id,
        'fecha'       => $fecha,
        'descripcion' => $descripcion,
        'haber'       => $montoChofer,
        'trip_id'     => $tripId,
        'user_id'     => $userId,
    ]);

    $insertados++;
}

// Mensaje y vuelta a la CC con el mismo mes/año
if ($insertados > 0) {
    $_SESSION['success'] = "Se importaron $insertados viaje(s) del período seleccionado.";
} else {
    $_SESSION['info'] = "No había viajes nuevos para importar en ese período.";
}

header("Location: cc.php?id={$driver_id}&mes={$mes}&anio={$anio}");
exit;