<?php
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

$doc_id       = $_POST['doc_id']        ?? null;
$subject_type = $_POST['subject_type']  ?? null;   // 'vehicle' | 'driver' | 'company'
$subject_id   = $_POST['subject_id']    ?? null;
$doc_type_id  = $_POST['doc_type_id']   ?? null;
$vencimiento  = $_POST['vencimiento']   ?? null;   // 'YYYY-MM-DD' o ''
$lugar        = trim($_POST['lugar']    ?? '');

if (!$subject_type || !$subject_id || !$doc_type_id) {
  $_SESSION['error'] = "Datos incompletos.";
  header('Location: index.php'); exit;
}

// Helpers para nombres
function getRef($pdo,$subject_type,$subject_id){
  if ($subject_type==='vehicle') {
    $q=$pdo->prepare("SELECT patente FROM vehicles WHERE id=?"); $q->execute([$subject_id]);
    return $q->fetchColumn() ?: 'REF';
  } elseif ($subject_type==='driver') {
    $q=$pdo->prepare("SELECT CONCAT(nombre,' ',apellido) FROM drivers WHERE id=?"); $q->execute([$subject_id]);
    return $q->fetchColumn() ?: 'REF';
  } elseif ($subject_type==='company') {
    return 'Macher';
  }
  return 'REF';
}
function getDocTypeName($pdo,$id){
  $q=$pdo->prepare("SELECT nombre FROM doc_types WHERE id=?"); $q->execute([$id]);
  return $q->fetchColumn() ?: 'Documento';
}

$ref   = getRef($pdo,$subject_type,$subject_id);
$tipoN = getDocTypeName($pdo,$doc_type_id);

// Directorio final
$baseDir = realpath(__DIR__ . '/../../') . '/storage/docs/';
$subDir  = $subject_type . '/' . preg_replace('/[^A-Za-z0-9_\-]/','_', $ref) . '/';
$dir     = $baseDir . $subDir;
if (!is_dir($dir)) @mkdir($dir, 0775, true);

// ¿Vino archivo?
$hayArchivo = (isset($_FILES['archivo']) && $_FILES['archivo']['error'] === UPLOAD_ERR_OK);
$rel = null; $hash = null;

if ($hayArchivo) {
  // Nombre: "REF – TIPO.pdf"
  $downloadName = "{$ref} – {$tipoN}.pdf";
  $finalPathAbs = $dir . $downloadName;
  if (!@move_uploaded_file($_FILES['archivo']['tmp_name'], $finalPathAbs)) {
    $_SESSION['error'] = "No se pudo guardar el archivo.";
    header('Location: index.php'); exit;
  }
  $hash = hash_file('sha256', $finalPathAbs);
  $rel  = 'storage/docs/' . $subDir . $downloadName;
}

try {
  if ($doc_id) {
    // EDITAR EXISTENTE
    if ($hayArchivo) {
      $stmt = $pdo->prepare("UPDATE documents 
        SET vencimiento = ?, lugar = ?, file_path = ?, file_hash = ?, uploaded_at = NOW(), uploaded_by = ?
        WHERE id = ?");
      $stmt->execute([
        $vencimiento ?: null,
        $lugar ?: null,
        $rel,
        $hash,
        $_SESSION['user_id'] ?? null,
        $doc_id
      ]);
    } else {
      // Solo editar metadatos (conservar archivo)
      $stmt = $pdo->prepare("UPDATE documents 
        SET vencimiento = ?, lugar = ?, uploaded_at = NOW(), uploaded_by = ?
        WHERE id = ?");
      $stmt->execute([
        $vencimiento ?: null,
        $lugar ?: null,
        $_SESSION['user_id'] ?? null,
        $doc_id
      ]);
    }
  } else {
    // NUEVO DOCUMENTO (con o sin archivo)
    $stmt = $pdo->prepare("INSERT INTO documents
      (subject_type, subject_id, doc_type_id, vencimiento, lugar, file_path, file_hash, uploaded_at, uploaded_by)
      VALUES (?,?,?,?,?,?,?,?,?)");
    $stmt->execute([
      $subject_type,
      $subject_id,
      $doc_type_id,
      $vencimiento ?: null,
      $lugar ?: null,
      $rel,       // puede ser null si no adjuntó
      $hash,      // puede ser null si no adjuntó
      date('Y-m-d H:i:s'),
      $_SESSION['user_id'] ?? null
    ]);
  }

  $_SESSION['success'] = "Documento guardado.";
} catch (Exception $e) {
  $_SESSION['error'] = "Error al guardar: " . $e->getMessage();
}

header('Location: index.php');