<?php
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();


/* Datos base */
$vehicles = $pdo->query("SELECT id, patente FROM vehicles ORDER BY patente")->fetchAll(PDO::FETCH_ASSOC);
$drivers  = $pdo->query("SELECT id, CONCAT(nombre,' ',apellido) AS nombre
                         FROM drivers
                         WHERE estado = 1
                         ORDER BY nombre")->fetchAll(PDO::FETCH_ASSOC);


 $docTypesVeh = $pdo->query("
  SELECT id, nombre
  FROM doc_types
  WHERE scope='vehicle'
  ORDER BY FIELD(nombre,
    'RTO',
    'SENASA',
    'Póliza',
    'Póliza pago',
    'Tarjeta circulación',
    'Cédula',
    'Matafuego'
  ), id
")->fetchAll(PDO::FETCH_ASSOC);


/* Tipos Macher (orden específico con IIBB y CM05) */
$docTypesCo = $pdo->query("
  SELECT id, nombre
  FROM doc_types
  WHERE scope='company'
  ORDER BY FIELD(nombre,
    'CBU','CUIT','IIBB','CM05','F931','Pago F931',
    'Pago aportes sindicales','Recibo de sueldos','Nómina','Póliza','Otros'
  ), id
")->fetchAll(PDO::FETCH_ASSOC);

/* Macher como sujeto único */
$company = ['id' => 1, 'nombre' => 'Macher'];

/* Tipos de documentos de CHOFER (consulta segura) */
$docTypesDr = $pdo->query("
  SELECT id, nombre
  FROM doc_types
  WHERE scope='driver'
  ORDER BY FIELD(nombre,
    'DNI',
    'Licencia',
    'Psicofísico',
    'Charla',
    'Carga peligrosa',
    'Alta temprana',
    'ASSAL'
  ), id
")->fetchAll(PDO::FETCH_ASSOC);



$stmt = $pdo->query("
  SELECT d.*, dt.nombre AS tipo_nombre
  FROM documents d
  JOIN doc_types dt ON dt.id = d.doc_type_id
");
$docs = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* Indexar por clave */
$grid = [];
foreach ($docs as $r) {
  $grid[$r['subject_type']][$r['subject_id']][$r['doc_type_id']] = $r;
}

/* Helpers locales (colores & paths alineados a tu look&feel) */
function days_to($date) {
  if (!$date) return null;
  $d = new DateTime($date);
  $today = new DateTime('today');
  return (int)$today->diff($d)->format('%r%a');
}
function doc_color_class(?string $venc, bool $hasFile): string {
  if (!$venc || !$hasFile) return 'badge-gray';     // gris: sin fecha o sin archivo
  $d = days_to($venc);
  if ($d < 0)               return 'badge-bordo';   // vencido (bordó)
  if ($d <= 30)             return 'badge-red';     // 0-30 → rojo
  if ($d <= 60)             return 'badge-orange';  // 31-60 → naranja
  return 'badge-green';                             // +60 → verde
}
function cell($subjectType, $subjectId, $ref, $docTypeId, $docTypeName, $grid) {
  $r = $grid[$subjectType][$subjectId][$docTypeId] ?? null;
  $hasFile   = $r && !empty($r['file_path']);
  $venc      = $r['vencimiento'] ?? null;
  $colorCls  = doc_color_class($venc, $hasFile);
  $fechaTxt  = $venc ? date('d/m/y', strtotime($venc)) : '—';
  $docId     = $r['id'] ?? '';
  $lugar     = $r['lugar'] ?? '';

  echo "<div class='doc-cell'>";
    echo "<span class='badge $colorCls' title='Lugar: ".htmlspecialchars($lugar)."'>$fechaTxt</span>";
 
  if ($hasFile) {
  echo " <a class='icon' href='download.php?id={$docId}' title='Descargar'><i class='bi bi-download'></i></a>";
  echo " <a class='icon' href='#'
            data-open-upload
            data-doc-id='{$docId}'
            data-subject-type='{$subjectType}'
            data-subject-id='{$subjectId}'
            data-doc-type-id='{$docTypeId}'
            data-ref='".htmlspecialchars($ref,ENT_QUOTES)."'
            data-doc-type='".htmlspecialchars($docTypeName,ENT_QUOTES)."'
            data-venc='".htmlspecialchars($venc ?? "", ENT_QUOTES)."'
            data-lugar='".htmlspecialchars($lugar ?? "", ENT_QUOTES)."'
            title='Editar / Reemplazar'>
            <i class='bi bi-arrow-repeat'></i>
         </a>";
} else {
  echo " <a class='icon' href='#'
            data-open-upload
            data-doc-id=''
            data-subject-type='{$subjectType}'
            data-subject-id='{$subjectId}'
            data-doc-type-id='{$docTypeId}'
            data-ref='".htmlspecialchars($ref,ENT_QUOTES)."'
            data-doc-type='".htmlspecialchars($docTypeName,ENT_QUOTES)."'
            data-venc=''
            data-lugar=''
            title='Subir PDF'>
            <i class='bi bi-cloud-upload'></i>
         </a>";
}


    $disabled = $hasFile ? "" : "disabled";
    $valueSel = $hasFile ? $docId : "";
    echo " <input type='checkbox' class='form-check-input doc-check' name='docs[]' value='{$valueSel}' {$disabled}>";
  echo "</div>";
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Documentación</title>

  <!-- Bootstrap + Icons (mismo stack que Trips) -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

  <style>
    /* Colores y tipografías como Trips */
    :root { --nav-bg:#1f2b35; --brand-blue:#0d6efd; --success-green:#198754; --brand-orange:#f68b1e; --danger-red:#dc3545; }
    body { background-color:#f6f7f8; font-family:"Segoe UI", Arial, sans-serif; font-size:14px; color:#222; margin:0; padding:0; }
    .content-wrap { margin-top:82px; padding-bottom:40px; }
    .page-card { border-radius:8px; border:1px solid #e6e9ec; background:#fff; }

    /* Badges de semáforo */
    .badge{padding:4px 8px;border-radius:8px;font-size:12px;display:inline-block}
    .badge-green   { background:#198754; color:#fff; }  /* verde sistema */
    .badge-orange  { background:#f68b1e; color:#fff; }  /* naranja sistema */
    .badge-red     { background:#dc3545; color:#fff; }  /* rojo sistema */
    .badge-bordo   { background:#991b1b; color:#fff; }  /* vencido (bordó suave) */
    .badge-gray    { background:#9ca3af; color:#fff; }  /* gris neutro */

    .doc-cell{display:flex;align-items:center;gap:8px;justify-content:flex-start}
    .icon{padding:0 4px;text-decoration:none;color:#0d6efd}
    .icon:hover{filter:brightness(0.9)}

    table th, table td{vertical-align:middle; white-space:nowrap;}
    .section{margin-top:22px}
  </style>
</head>
<body>
<?php include "../assets/nav2.php"; ?>

<div class="content-wrap container">
  <div class="page-card card">
    <div class="card-body">
      <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0 text-primary fw-bold">Documentación</h5>
      </div>
<!-- Macher (Company) encabezado-fila / datos / encabezado-fila / datos -->
<div class="section card p-3 mb-3">
  <h5 class="fw-bold mb-3">Macher</h5>
  <div class="table-responsive">
    <table class="table table-striped align-middle">
      <?php
        // Dividimos los documentos en 2 grupos
        $co_first  = array_slice($docTypesCo, 0, 6);
        $co_second = array_slice($docTypesCo, 6);
      ?>

      <tbody>
        <!-- PRIMER BLOQUE -->
        <tr class="table-light">
          <th style="min-width:160px">Referencia</th>
          <?php foreach($co_first as $dt){ ?>
            <th><?= htmlspecialchars($dt['nombre']) ?></th>
          <?php } ?>
        </tr>
        <tr>
          <td><strong><?= htmlspecialchars($company['nombre']) ?></strong></td>
          <?php foreach($co_first as $dt){ ?>
            <td><?php cell('company', $company['id'], $company['nombre'], $dt['id'], $dt['nombre'], $grid); ?></td>
          <?php } ?>
        </tr>

        <!-- SEGUNDO BLOQUE -->
        <tr class="table-light">
          <th style="min-width:160px"></th> <!-- vacío para mantener alineación -->
          <?php foreach($co_second as $dt){ ?>
            <th><?= htmlspecialchars($dt['nombre']) ?></th>
          <?php } ?>
        </tr>
        <tr>
          <td></td>
          <?php foreach($co_second as $dt){ ?>
            <td><?php cell('company', $company['id'], $company['nombre'], $dt['id'], $dt['nombre'], $grid); ?></td>
          <?php } ?>
        </tr>
      </tbody>
    </table>
  </div>
</div>


</div>



      <form id="bulkForm" method="post" action="bulk_zip.php">
        <!-- Vehículos -->
        <div class="section card p-3">
          <h5 class="fw-bold mb-3">Patentes (Vehículos)</h5>
          <div class="table-responsive">
            <table class="table table-striped align-middle">
              <thead class="table-light">
              <tr>
                <th>Patente</th>
                <?php foreach($docTypesVeh as $dt){ echo "<th>".htmlspecialchars($dt['nombre'])."</th>"; } ?>
              </tr>
              </thead>
              <tbody>
              <?php foreach($vehicles as $v): ?>
                <tr>
                  <td><strong><?= htmlspecialchars($v['patente']) ?></strong></td>
                  <?php foreach($docTypesVeh as $dt){ ?>
  <td><?php cell('vehicle', $v['id'], $v['patente'], $dt['id'], $dt['nombre'], $grid); ?></td>
<?php } ?>

                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </div>

        <!-- Choferes -->
<div class="section card p-3">
  <h5 class="fw-bold mb-3">Choferes</h5>
  <div class="table-responsive">
    <table class="table table-striped align-middle">
      <thead class="table-light">
        <tr>
          <th>Chofer</th>
          <?php foreach($docTypesDr as $dt){ ?>
            <th><?= htmlspecialchars($dt['nombre']) ?></th>
          <?php } ?>
        </tr>
      </thead>
      <tbody>
        <?php foreach($drivers as $d){ ?>
          <tr>
            <td><strong><?= htmlspecialchars($d['nombre']) ?></strong></td>
            <?php foreach($docTypesDr as $dt){ ?>
              <td><?php cell('driver', $d['id'], $d['nombre'], $dt['id'], $dt['nombre'], $grid); ?></td>
            <?php } ?>
          </tr>
        <?php } ?>
      </tbody>
    </table>
  </div>
</div>


        <div class="my-3 d-flex gap-2">
          <button type="submit" class="btn btn-primary">Descargar seleccionados (ZIP)</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Modal subir/reemplazar -->
<div class="modal" id="upModal" tabindex="-1">
  <div class="modal-dialog">
    <form class="modal-content" method="post" action="upload.php" enctype="multipart/form-data">
      <div class="modal-header">
        <h5 class="modal-title">Cargar/Reemplazar documento</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="mb-2">
          <label class="form-label">Referencia</label>
          <input class="form-control" id="upRef" disabled>
        </div>
        <div class="mb-2">
          <label class="form-label">Tipo de documento</label>
          <input class="form-control" id="upDocType" disabled>
        </div>
        <div class="mb-2">
          <label class="form-label">Fecha vencimiento</label>
          <!-- Fecha opcional (si querés editar solo Lugar) -->
<input type="date" class="form-control" name="vencimiento" id="upVenc">
        </div>
        <div class="mb-2">
          <label class="form-label">Lugar</label>
          <input type="text" class="form-control" name="lugar" id="upLugar" placeholder="Ej: Oficina / Drive RRHH">
        </div>
        <div class="mb-2">
          <label class="form-label">Archivo (PDF)</label>
          <!-- Archivo PDF OPCIONAL (si no subís, se conserva el anterior) -->
<input type="file" class="form-control" name="archivo" accept="application/pdf">

        </div>
        <input type="hidden" name="doc_id" id="upDocId">
        <input type="hidden" name="subject_type" id="upSubType">
        <input type="hidden" name="subject_id" id="upSubId">
        <input type="hidden" name="doc_type_id" id="upTypeId">
<small id="fileHelp" class="text-muted">Si no seleccionás un PDF nuevo, se conserva el archivo anterior.</small>

      </div>
      <div class="modal-footer">
        <button class="btn btn-success" type="submit">Guardar</button>
      </div>
    </form>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.querySelectorAll('[data-open-upload]').forEach(el=>{
  el.addEventListener('click', e=>{
    e.preventDefault();
    const m = document.getElementById('upModal');

    // Completar cabecera
    document.getElementById('upRef').value      = el.dataset.ref || '';
    document.getElementById('upDocType').value  = el.dataset.docType || '';

    // IDs para backend
    document.getElementById('upDocId').value    = el.dataset.docId || '';
    document.getElementById('upSubType').value  = el.dataset.subjectType;
    document.getElementById('upSubId').value    = el.dataset.subjectId;
    document.getElementById('upTypeId').value   = el.dataset.docTypeId;

    // Prefill de vencimiento y lugar (si hay)
    document.getElementById('upVenc').value  = el.dataset.venc || '';
    document.getElementById('upLugar').value = el.dataset.lugar || '';

    // Título dinámico
    const title = m.querySelector('.modal-title');
    title.textContent = (el.dataset.docId && el.dataset.docId !== '') ? 'Editar / Reemplazar documento' : 'Cargar documento';

    // Sugerencia dinámica (mostrar cuando ya hay documento)
    const help = m.querySelector('#fileHelp');
    if (help) help.style.display = (el.dataset.docId && el.dataset.docId !== '') ? 'block' : 'none';

    new bootstrap.Modal(m).show();
  });
});
</script>
</body>
</html>