<?php
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

$id = (int)($_GET['id'] ?? 0);
if (!$id) { http_response_code(404); exit; }

$stmt = $pdo->prepare("
  SELECT d.*, dt.nombre AS tipo,
         CASE 
           WHEN d.subject_type='vehicle' THEN v.patente 
           WHEN d.subject_type='driver'  THEN CONCAT(dr.nombre,' ',dr.apellido)
           WHEN d.subject_type='company' THEN 'Macher'
         END AS ref
  FROM documents d
  JOIN doc_types dt ON dt.id = d.doc_type_id
  LEFT JOIN vehicles v ON d.subject_type='vehicle' AND v.id = d.subject_id
  LEFT JOIN drivers  dr ON d.subject_type='driver'  AND dr.id = d.subject_id
  WHERE d.id = ?
");

$stmt->execute([$id]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$row || empty($row['file_path'])) { http_response_code(404); exit; }

$abs = realpath(__DIR__ . '/../../' . $row['file_path']);
if (!$abs || !file_exists($abs)) { http_response_code(404); exit; }

$downloadName = "{$row['ref']} – {$row['tipo']}.pdf";
header('Content-Type: application/pdf');
header('Content-Length: ' . filesize($abs));
header('Content-Disposition: attachment; filename="' . $downloadName . '"');
readfile($abs);