<?php
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

$ids = $_POST['docs'] ?? [];
if (empty($ids)) { $_SESSION['error']="Seleccioná al menos un documento."; header('Location: index.php'); exit; }

$in  = implode(',', array_fill(0, count($ids), '?'));
$stmt = $pdo->prepare("
 SELECT d.*, dt.nombre AS tipo,
        CASE WHEN d.subject_type='vehicle' THEN v.patente ELSE CONCAT(dr.nombre,' ',dr.apellido) END AS ref
 FROM documents d
 JOIN doc_types dt ON dt.id = d.doc_type_id
 LEFT JOIN vehicles v ON d.subject_type='vehicle' AND v.id = d.subject_id
 LEFT JOIN drivers  dr ON d.subject_type='driver'  AND dr.id = d.subject_id
 WHERE d.id IN ($in) AND d.file_path IS NOT NULL
");
$stmt->execute($ids);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
if (!$rows) { $_SESSION['error']="No hay archivos para comprimir."; header('Location: index.php'); exit; }

$zipName = 'Documentacion_' . date('Ymd_His') . '.zip';
$tmpZip  = sys_get_temp_dir() . '/' . $zipName;

$zip = new ZipArchive();
$zip->open($tmpZip, ZipArchive::CREATE|ZipArchive::OVERWRITE);
foreach ($rows as $r) {
  $abs = realpath(__DIR__ . '/../../' . $r['file_path']);
  if ($abs && file_exists($abs)) {
    $downloadName = "{$r['ref']} – {$r['tipo']}.pdf";
    $zip->addFile($abs, $downloadName);
  }
}
$zip->close();

header('Content-Type: application/zip');
header('Content-Length: ' . filesize($tmpZip));
header('Content-Disposition: attachment; filename="'.$zipName.'"');
readfile($tmpZip);
unlink($tmpZip);