<?php
/**
 * app/public/customers/update.php
 */
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header('Location: index.php'); exit;
}

$id              = $_POST['id'] ?? null;
$cuit            = trim($_POST['cuit'] ?? '');
$razon_social    = trim($_POST['razon_social'] ?? '');
$telefono        = trim($_POST['telefono'] ?? '');
$email           = trim($_POST['email'] ?? '');
$email_alt       = trim($_POST['email_alt'] ?? '');
$medio_pago      = trim($_POST['medio_pago'] ?? '');
$tipo_cliente    = $_POST['tipo_cliente'] ?? 'Empresa';
$estado          = $_POST['estado'] ?? 'Activo';
$comentario      = trim($_POST['comentario_predef'] ?? '');

if (!$id || !$razon_social) {
  $_SESSION['error'] = "Faltan datos obligatorios.";
  header("Location: edit.php?id=".(int)$id); exit;
}

try {
  $sql = "UPDATE customers SET
            cuit = :cuit,
            razon_social = :razon_social,
            telefono = :telefono,
            email = :email,
            email_alt = :email_alt,
            medio_pago = :medio_pago,
            tipo_cliente = :tipo_cliente,
            estado = :estado,
            comentario_predef = :comentario_predef,
            updated_at = NOW()
          WHERE id = :id";
  $stmt = $pdo->prepare($sql);
  $stmt->execute([
    'cuit' => $cuit,
    'razon_social' => $razon_social,
    'telefono' => $telefono,
    'email' => $email,
    'email_alt' => $email_alt,
    'medio_pago' => $medio_pago,
    'tipo_cliente' => $tipo_cliente,
    'estado' => $estado,
    'comentario_predef' => $comentario,
    'id' => $id
  ]);

  // Log
  $pdo->prepare("INSERT INTO logs (grupo,tipo,cambios,id_modif,user,fecha)
                 VALUES ('cliente',2,:cambios,:id_modif,:user,NOW())")
      ->execute([
        'cambios'  => json_encode(['id'=>$id,'razon_social'=>$razon_social], JSON_UNESCAPED_UNICODE),
        'id_modif' => $id,
        'user'     => $_SESSION['user_id'] ?? 0
      ]);

  $_SESSION['success'] = "Cliente actualizado.";
  header('Location: index.php');
  exit;

} catch (Exception $e) {
  $_SESSION['error'] = "No se pudo actualizar el cliente.";
  header("Location: edit.php?id=".(int)$id);
  exit;
}