<?php
/**
 * public/customers/store.php
 * Guarda un cliente nuevo (ABM Clientes)
 */
session_start();
require_once '../../config/db.php';

// Solo POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit;
}

// 1) Tomar y normalizar datos
$cuit             = trim($_POST['cuit'] ?? '');
$razon_social     = trim($_POST['razon_social'] ?? '');
$telefono         = trim($_POST['telefono'] ?? '');
$email            = trim($_POST['email'] ?? '');
$email_alt        = trim($_POST['email_alt'] ?? '');
$comentario_predef= trim($_POST['comentario_predef'] ?? '');
$medio_pago       = trim($_POST['medio_pago'] ?? '');
$tipo_cliente     = trim($_POST['tipo_cliente'] ?? '');

// Validaciones mínimas
$errores = [];
if ($cuit === '')           $errores[] = 'El CUIT es obligatorio.';
if ($razon_social === '')   $errores[] = 'La Razón Social es obligatoria.';

// Opcional: formato cuit simple (dejamos dígitos y guiones)
$cuit = preg_replace('/[^0-9\-]/', '', $cuit);

// Si hay errores, volver
if ($errores) {
    $_SESSION['error'] = implode(' ', $errores);
    header('Location: create.php');
    exit;
}

try {
    // 2) Verificar CUIT único
    $q = $pdo->prepare("SELECT id FROM customers WHERE cuit = :cuit LIMIT 1");
    $q->execute(['cuit' => $cuit]);
    if ($q->fetch()) {
        $_SESSION['error'] = 'Ya existe un cliente con ese CUIT.';
        header('Location: create.php');
        exit;
    }

    // 3) Insertar
    $sql = "INSERT INTO customers
            (cuit, razon_social, telefono, email, email_alt, comentario_predef,
             medio_pago, tipo_cliente, estado, created_at, updated_at)
            VALUES
            (:cuit, :razon_social, :telefono, :email, :email_alt, :comentario_predef,
             :medio_pago, :tipo_cliente, 'Activo', NOW(), NOW())";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'cuit'              => $cuit,
        'razon_social'      => $razon_social,
        'telefono'          => $telefono,
        'email'             => $email,
        'email_alt'         => $email_alt,
        'comentario_predef' => $comentario_predef,
        'medio_pago'        => $medio_pago,
        'tipo_cliente'      => $tipo_cliente,
    ]);

    $_SESSION['success'] = 'Cliente creado correctamente.';
    header('Location: index.php');
    exit;

} catch (Exception $e) {
    // Log interno si querés: error_log($e->getMessage());
    $_SESSION['error'] = 'Ocurrió un error al guardar el cliente.';
    header('Location: create.php');
    exit;
}