<?php
/**
 * app/public/customers/search_customers.php
 * Devuelve JSON: [{id, text, comentario}]
 */
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

$term = trim($_GET['term'] ?? '');

$sql = "SELECT id, razon_social, cuit, comentario_predef
        FROM customers
        WHERE estado = 'Activo' ";
$params = [];

if ($term !== '') {
  $sql .= "AND (razon_social LIKE :t OR cuit LIKE :t) ";
  $params['t'] = "%$term%";
}
$sql .= "ORDER BY razon_social LIMIT 20";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);

$out = [];
while ($r = $stmt->fetch(PDO::FETCH_ASSOC)) {
  $text = $r['razon_social'];
  if (!empty($r['cuit'])) $text .= " — CUIT: ".$r['cuit'];
  $out[] = [
    'id'   => (int)$r['id'],
    'text' => $text,
    'comentario' => $r['comentario_predef'] ?? ''
  ];
}
header('Content-Type: application/json; charset=utf-8');
echo json_encode($out, JSON_UNESCAPED_UNICODE);