<?php
/**
 * public/customers/get_cliente.php
 * Devuelve datos del cliente en formato JSON para autocompletar en crear/editar viaje.
 */

require_once __DIR__ . '/../../config/db.php';

header('Content-Type: application/json; charset=utf-8');

$id = $_GET['id'] ?? null;

if (!$id) {
    echo json_encode(['error' => 'Falta el ID del cliente.']);
    exit;
}

try {
    $stmt = $pdo->prepare("
        SELECT 
            id,
            cuit,
            razon_social,
            telefono,
            email,
            comentario_predef,
            medio_pago
        FROM customers
        WHERE id = :id
        LIMIT 1
    ");
    $stmt->execute(['id' => $id]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$cliente) {
        echo json_encode(['error' => 'Cliente no encontrado.']);
        exit;
    }

    echo json_encode([
        'id' => $cliente['id'],
        'cuit' => $cliente['cuit'],
        'razon_social' => $cliente['razon_social'],
        'telefono' => $cliente['telefono'],
        'email' => $cliente['email'],
        'medio_pago' => $cliente['medio_pago'],
        'comentario' => $cliente['comentario_predef']
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    echo json_encode([
        'error' => 'Error al obtener datos del cliente.',
        'detalle' => $e->getMessage()
    ]);
}