<?php
/**
 * app/public/customers/edit.php
 * Edición de cliente con encabezado unificado (nav2) y hovers sin movimiento
 */
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

$id = $_GET['id'] ?? null;
if (!$id) { header('Location: index.php'); exit; }

$stmt = $pdo->prepare("SELECT * FROM customers WHERE id = :id LIMIT 1");
$stmt->execute(['id' => $id]);
$c = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$c) { header('Location: index.php'); exit; }
?>
<!DOCTYPE html>
<html lang="es" class="h-full bg-white">
<head>
  <meta charset="utf-8">
  <title>Editar Cliente - Macher</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Tailwind + Bootstrap -->
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- Bootstrap Icons -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

  <style>
    :root { --nav-bg:#1f2b35; }
    body { background-color:#f8f9fa; font-family:"Inter",sans-serif; }

    .main-navbar {
      background:var(--nav-bg);
      border-bottom:1px solid rgba(0,0,0,.15);
      position:fixed; top:0; left:0; width:100%;
      z-index:1080; height:64px;
    }
    .content-wrap { margin-top:82px; padding-bottom:40px; }

    /* ✅ FIX: conflicto Tailwind vs Bootstrap en .collapse */
    .navbar .collapse { visibility: visible !important; }
    @media (max-width: 991.98px){
      .navbar .collapse { display: none; }
      .navbar .collapse.show { display: block; }
    }

    .card { border:1px solid #e5e7eb; border-radius:8px; }
    label { font-weight:500; color:#374151; }

    /* 🎯 Botones con hover SIN movimiento: solo oscurecer */
    .btn-primary.text-white,
    .btn-danger.text-white,
    .btn-dark.text-white {
      border: none !important;
      transition: filter .15s ease-in-out, background-color .15s ease-in-out;
    }
    .btn-primary.text-white:hover,
    .btn-danger.text-white:hover,
    .btn-dark.text-white:hover {
      filter: brightness(0.9);
    }
  </style>
</head>

<body class="h-full bg-white flex flex-col">
  <?php include "../assets/nav2.php"; ?>

  <main class="content-wrap container">
    <div class="card shadow-sm mx-auto" style="max-width:800px;">
      <div class="card-header bg-white d-flex justify-content-between align-items-center">
        <h5 class="mb-0 text-primary fw-bold">
          Editar Cliente <span class="text-muted">#<?= htmlspecialchars($c['id']) ?></span>
        </h5>
        <a href="index.php" class="btn btn-dark btn-sm text-white d-flex align-items-center gap-1">
          <i class="bi bi-arrow-left"></i> Volver
        </a>
      </div>

      <div class="card-body">
        <form action="update.php" method="POST" class="space-y-3">
          <input type="hidden" name="id" value="<?= htmlspecialchars($c['id']) ?>">

          <div class="row g-3">
            <div class="col-md-4">
              <label for="cuit" class="form-label">CUIT</label>
              <input type="text" id="cuit" name="cuit" value="<?= htmlspecialchars($c['cuit']) ?>" class="form-control" required>
            </div>
            <div class="col-md-8">
              <label for="razon_social" class="form-label">Razón Social</label>
              <input type="text" id="razon_social" name="razon_social" value="<?= htmlspecialchars($c['razon_social']) ?>" class="form-control" required>
            </div>
          </div>

          <div class="row g-3 mt-1">
            <div class="col-md-4">
              <label for="telefono" class="form-label">Teléfono</label>
              <input type="text" id="telefono" name="telefono" value="<?= htmlspecialchars($c['telefono'] ?? '') ?>" class="form-control">
            </div>
            <div class="col-md-4">
              <label for="medio_pago" class="form-label">Medio de pago habitual</label>
              <input type="text" id="medio_pago" name="medio_pago" value="<?= htmlspecialchars($c['medio_pago'] ?? '') ?>" class="form-control">
            </div>
            <div class="col-md-4">
              <label for="tipo_cliente" class="form-label">Tipo de Cliente</label>
              <select id="tipo_cliente" name="tipo_cliente" class="form-select">
                <?php
                  $opts = ['Productor','Acopio','Empresa','Planta'];
                  foreach ($opts as $o) {
                    $sel = ($c['tipo_cliente']===$o)?'selected':'';
                    echo "<option $sel>$o</option>";
                  }
                ?>
              </select>
            </div>
          </div>

          <div class="row g-3 mt-1">
            <div class="col-md-6">
              <label for="email" class="form-label">Email principal</label>
              <input type="email" id="email" name="email" value="<?= htmlspecialchars($c['email'] ?? '') ?>" class="form-control">
            </div>
            <div class="col-md-6">
              <label for="email_alt" class="form-label">Email alternativo</label>
              <input type="email" id="email_alt" name="email_alt" value="<?= htmlspecialchars($c['email_alt'] ?? '') ?>" class="form-control">
            </div>
          </div>

          <div class="row g-3 mt-1">
            <div class="col-md-6">
              <label for="estado" class="form-label">Estado</label>
              <select id="estado" name="estado" class="form-select">
                <option value="Activo" <?= $c['estado']==='Activo'?'selected':''; ?>>Activo</option>
                <option value="Inactivo" <?= $c['estado']==='Inactivo'?'selected':''; ?>>Inactivo</option>
              </select>
            </div>
            <div class="col-md-6">
              <label for="comentario_predef" class="form-label">Comentario predefinido</label>
              <textarea id="comentario_predef" name="comentario_predef" rows="2" class="form-control"><?= htmlspecialchars($c['comentario_predef'] ?? '') ?></textarea>
            </div>
          </div>

          <div class="mt-4 d-flex justify-content-end gap-2">
            <a href="index.php" class="btn btn-dark btn-sm text-white d-flex align-items-center gap-1">
              <i class="bi bi-x-lg"></i> Cancelar
            </a>
            <button type="submit" class="btn btn-primary btn-sm text-white d-flex align-items-center gap-1">
              <i class="bi bi-save"></i> Guardar cambios
            </button>
          </div>
        </form>
      </div>
    </div>
  </main>

  <?php include "../assets/footer.php"; ?>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>