<?php
/**
 * app/public/customers/delete.php
 */
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

$id = $_GET['id'] ?? null;
if (!$id) { header('Location: index.php'); exit; }

try {
  // (Opcional) Verificar que no tenga viajes asociados
  $q = $pdo->prepare("SELECT COUNT(*) FROM trips WHERE customer_id = :id");
  $q->execute(['id'=>$id]);
  if ($q->fetchColumn() > 0) {
    $_SESSION['error'] = "No se puede borrar: el cliente tiene viajes asociados.";
    header('Location: index.php'); exit;
  }

  $pdo->prepare("DELETE FROM customers WHERE id = :id LIMIT 1")->execute(['id'=>$id]);

  // Log
  $pdo->prepare("INSERT INTO logs (grupo,tipo,cambios,id_modif,user,fecha)
                 VALUES ('cliente',3,:cambios,:id_modif,:user,NOW())")
      ->execute([
        'cambios'  => json_encode(['id'=>$id], JSON_UNESCAPED_UNICODE),
        'id_modif' => $id,
        'user'     => $_SESSION['user_id'] ?? 0
      ]);

  $_SESSION['success'] = "Cliente eliminado.";
  header('Location: index.php');
  exit;

} catch (Exception $e) {
  $_SESSION['error'] = "Error al eliminar el cliente.";
  header('Location: index.php'); exit;
}