<?php
session_start();
require_once '../../config/db.php';
require_once '../../helpers/functions.php';
check_auth();

// Flash (opcional)
$flash_success = $_SESSION['success'] ?? null;
$flash_error   = $_SESSION['error']   ?? null;
unset($_SESSION['success'], $_SESSION['error']);
?>
<!DOCTYPE html>
<html lang="es" class="h-full bg-white">
<head>
  <meta charset="UTF-8">
  <title>Nuevo Cliente - Macher</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Bootstrap Icons (para íconos de botones) -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

  <!-- Tailwind (para coherencia con el resto del sistema) -->
  <script src="https://cdn.tailwindcss.com"></script>

  <style>
    :root { --nav-bg:#1f2b35; }
    body { background:#f8f9fa; font-family:"Inter", sans-serif; }
    .main-navbar {
      background: var(--nav-bg);
      border-bottom: 1px solid rgba(0,0,0,.15);
      position: fixed;
      top: 0; left: 0;
      width: 100%;
      z-index: 1080;
      height: 64px;
    }
    .content-wrap { margin-top: 82px; padding-bottom: 40px; }
    .card { border: 1px solid #e5e7eb; }
    .form-label { font-weight: 500; color: #374151; }
    .hint { font-size: .85rem; color: #6b7280; }

    /* FIX: a veces Tailwind interfiere con el collapse de Bootstrap */
    .navbar .collapse { visibility: visible !important; }

    /* === Estilo de botones unificado (oscurece sin moverse) === */
    .btn { 
      transition: background-color .15s ease, filter .15s ease, color .15s ease;
    }
    .btn:hover, .btn:active, .btn:focus {
      transform: none !important;            /* sin desplazamientos */
    }
    .btn-primary:hover,
    .btn-dark:hover,
    .btn-secondary:hover {
      filter: brightness(0.9);               /* oscurece sutil */
    }
  </style>
</head>
<body class="h-full bg-white flex flex-col">
  <?php include "../assets/nav2.php"; ?>

  <main class="content-wrap container">
    <div class="row">
      <div class="col-12 col-lg-10 mx-auto">
        <div class="card shadow-sm">
          <div class="card-header bg-white d-flex justify-content-between align-items-center">
            <div>
              <h5 class="mb-0">Alta de Cliente</h5>
              <small class="text-muted">Complete los datos y guarde</small>
            </div>
            <a href="index.php" class="btn btn-dark btn-sm text-white d-flex align-items-center gap-1">
              <i class="bi bi-arrow-left"></i> Volver
            </a>
          </div>

          <div class="card-body">
            <?php if ($flash_success): ?>
              <div class="alert alert-success"><?= htmlspecialchars($flash_success) ?></div>
            <?php endif; ?>
            <?php if ($flash_error): ?>
              <div class="alert alert-danger"><?= htmlspecialchars($flash_error) ?></div>
            <?php endif; ?>

            <form action="store.php" method="POST" novalidate>
              <!-- Fila 1 -->
              <div class="row g-3">
                <div class="col-md-4">
                  <label for="cuit" class="form-label">CUIT <span class="text-danger">*</span></label>
          <input type="text" id="cuit" name="cuit" 
       class="form-control" 
       placeholder="Ej: 30711223345"
       inputmode="numeric" 
       pattern="[0-9]*" 
       maxlength="11" 
       oninput="this.value = this.value.replace(/[^0-9]/g, '');">
        

                  <div class="hint mt-1">Solo números y guiones. Se valida al guardar.</div>
                </div>
                <div class="col-md-8">
                  <label for="razon_social" class="form-label">Razón Social <span class="text-danger">*</span></label>
                  <input
                    type="text"
                    class="form-control"
                    id="razon_social"
                    name="razon_social"
                    placeholder="Ej: Acopios del Centro S.A."
                    required
                  >
                </div>
              </div>

              <!-- Fila 2 -->
              <div class="row g-3 mt-1">
                <div class="col-md-4">
                  <label for="telefono" class="form-label">Teléfono</label>
                  <input
                    type="text"
                    class="form-control"
                    id="telefono"
                    name="telefono"
                    inputmode="tel"
                    placeholder="Ej: 351-5555555"
                  >
                </div>
                <div class="col-md-4">
                  <label for="email" class="form-label">Email principal</label>
                  <input
                    type="email"
                    class="form-control"
                    id="email"
                    name="email"
                    placeholder="cliente@ejemplo.com"
                  >
                </div>
                <div class="col-md-4">
                  <label for="email_alt" class="form-label">Email alternativo</label>
                  <input
                    type="email"
                    class="form-control"
                    id="email_alt"
                    name="email_alt"
                    placeholder="administracion@ejemplo.com"
                  >
                </div>
              </div>

              <!-- Comentario predefinido -->
              <div class="mt-3">
                <label for="comentario_predef" class="form-label">Comentario predefinido</label>
                <textarea
                  class="form-control"
                  id="comentario_predef"
                  name="comentario_predef"
                  rows="2"
                  placeholder="Observaciones o instrucciones habituales (se completan automáticamente al crear viajes)"
                ></textarea>
              </div>

              <!-- Fila 3 -->
              <div class="row g-3 mt-1">
                <div class="col-md-6">
                  <label for="medio_pago" class="form-label">Medio de pago habitual</label>
                  <input
                    type="text"
                    class="form-control"
                    id="medio_pago"
                    name="medio_pago"
                    placeholder="Ej: Transferencia, Contado, Cheque..."
                  >
                </div>
                <div class="col-md-6">
                  <label for="tipo_cliente" class="form-label">Tipo de cliente <span class="text-danger">*</span></label>
                  <select
                    id="tipo_cliente"
                    name="tipo_cliente"
                    class="form-select"
                    required
                  >
                    <option value="Productor">Productor</option>
                    <option value="Acopio">Acopio</option>
                    <option value="Empresa">Empresa</option>
                    <option value="Planta">Planta</option>
                  </select>
                </div>
              </div>

              <!-- Botones -->
              <div class="mt-4 d-flex gap-2">
                <button type="submit" class="btn btn-primary d-flex align-items-center gap-1">
                  <i class="bi bi-save"></i> Guardar Cliente
                </button>
                <a href="index.php" class="btn btn-dark text-white d-flex align-items-center gap-1">
                  <i class="bi bi-arrow-left"></i> Cancelar
                </a>
              </div>
            </form>

          </div>
        </div>
      </div>
    </div>
  </main>

  <?php include "../assets/footer.php"; ?>

  <!-- JS Bootstrap -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>