<?php
// Habilitar la visualización de errores en el navegador (modo desarrollo)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


session_start();
require_once "../config/db.php";
require_once "../helpers/functions.php";

// Solo procesar si se envía por POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    redirect('change.php');
}

$current_password = $_POST['current_password'] ?? '';
$new_password     = $_POST['new_password'] ?? '';
$confirm_password = $_POST['confirm_password'] ?? '';

// Validar que no hayan campos vacíos
if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
    redirect('change.php?error=3');
}

// Validar que la nueva contraseña y la confirmación coincidan
if ($new_password !== $confirm_password) {
    redirect('change.php?error=2');
}

// Obtener el hash de la contraseña actual del usuario
$stmt = $pdo->prepare("SELECT password FROM users WHERE id = :id LIMIT 1");
$stmt->execute(['id' => $_SESSION['user_id']]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    // Si el usuario no se encuentra, redirigir al login
    redirect('login.php');
}

// Verificar que la contraseña actual ingresada sea correcta
if (!password_verify($current_password, $user['password'])) {
    redirect('change.php?error=1');
}

// Todo es correcto, actualizar la contraseña
$new_hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
$updateStmt = $pdo->prepare("UPDATE users SET password = :password WHERE id = :id");
$result = $updateStmt->execute([
    'password' => $new_hashed_password,
    'id'       => $_SESSION['user_id']
]);

if ($result) {
    redirect('change.php?success=1');
} else {
    redirect('change.php?error=3');
}
