<?php

// Habilitar la visualización de errores en el navegador (modo desarrollo)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require_once "../config/db.php";
require_once "../helpers/functions.php";

// Verificar que el usuario esté logueado, de lo contrario redirigir al login
if (empty($_SESSION['user_id'])) {
    redirect('login.php');
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Cambiar Contraseña</title>
  <!-- Tailwind CSS vía CDN -->
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body {
      background-color: #fff;
      font-family: 'Inter', sans-serif;
    }
  </style>
</head>
<body class="min-h-screen flex flex-col bg-white">
  <?php include "assets/nav.php"; ?>
  <main class="flex-grow pt-14">
    <div class="container mx-auto px-4 py-6">
      <!-- Card principal -->
      <div class="bg-white rounded-lg shadow p-6 max-w-md mx-auto">
        <h1 class="text-2xl font-bold mb-4">Cambiar mi contraseña</h1>
        
        <!-- Mostrar mensajes de error o éxito -->
        <?php if (isset($_GET['error'])): ?>
          <div class="mb-4 text-red-500">
            <?php 
              if ($_GET['error'] == 1) {
                  echo "La contraseña actual es incorrecta.";
              } elseif ($_GET['error'] == 2) {
                  echo "Las contraseñas nuevas no coinciden.";
              } elseif ($_GET['error'] == 3) {
                  echo "Ocurrió un error al intentar cambiar la contraseña.";
              }
            ?>
          </div>
        <?php endif; ?>
        <?php if (isset($_GET['success'])): ?>
          <div class="mb-4 text-green-500">
            Contraseña cambiada exitosamente.
          </div>
        <?php endif; ?>

        <form action="change_password_process.php" method="POST" class="space-y-4">
          <div>
            <label for="current_password" class="block text-gray-700 mb-1">Contraseña Actual</label>
            <input type="password" name="current_password" id="current_password" required class="w-full border border-gray-300 p-2 rounded">
          </div>
          <div>
            <label for="new_password" class="block text-gray-700 mb-1">Nueva Contraseña</label>
            <input type="password" name="new_password" id="new_password" required class="w-full border border-gray-300 p-2 rounded">
          </div>
          <div>
            <label for="confirm_password" class="block text-gray-700 mb-1">Confirmar Nueva Contraseña</label>
            <input type="password" name="confirm_password" id="confirm_password" required class="w-full border border-gray-300 p-2 rounded">
          </div>
          <button type="submit" class="w-full bg-blue-600 text-white p-2 rounded hover:bg-blue-700">Cambiar Contraseña</button>
        </form>

        
      </div>
    </div>
  </main>
  <?php include "assets/footer.php"; ?>
</body>
</html>
