<?php
// nav2.php — Header unificado (sin enlace en el logo)
$currentFile = basename($_SERVER['PHP_SELF']);
$currentDir  = basename(dirname($_SERVER['PHP_SELF']));
?>
<nav class="navbar navbar-expand-lg navbar-dark main-navbar fixed-top shadow" style="background:#1f2b35;">
  <div class="container-fluid">

    <!-- Logo solo estético (no clickeable) -->
    <div class="navbar-brand ms-3 d-flex align-items-center">
      <img src="/app/public/assets/img/logo.png"
           alt="Macher"
           class="logo-nav"
           width="120"
           height="34"
           style="height:34px;width:auto;object-fit:contain" />
    </div>

    <!-- Botón hamburguesa para móvil -->
    <button class="navbar-toggler me-3" type="button" data-bs-toggle="collapse" data-bs-target="#mainNav">
      <span class="navbar-toggler-icon"></span>
    </button>

    <!-- Menú principal -->
    <div class="collapse navbar-collapse" id="mainNav">
     <ul class="navbar-nav ms-3 me-auto">
  <li class="nav-item"><a class="nav-link <?php echo ($currentFile == 'dashboard.php') ? 'active-link' : ''; ?>" href="/app/public/dashboard.php">Inicio</a></li>
  <li class="nav-item"><a class="nav-link <?php echo ($currentDir == 'trips') ? 'active-link' : ''; ?>" href="/app/public/trips/index.php">Viajes</a></li>

  <!-- 🔢 Calculadora con icono -->
  <li class="nav-item">
    <a class="nav-link <?php echo ($currentDir == 'calculator') ? 'active-link' : ''; ?>" href="/app/public/calculator/index.php" title="Calculadora">
      <i class="bi bi-calculator"></i>
    </a>
  </li>

  <!-- Subimos Documentación antes que Choferes -->
  <li class="nav-item"><a class="nav-link <?php echo ($currentDir == 'docs') ? 'active-link' : ''; ?>" href="/app/public/docs/index.php">Documentación</a></li>

<li class="nav-item">
  <a class="nav-link <?php echo ($currentDir == 'fuel') ? 'active-link' : ''; ?>"
     href="/app/public/fuel/index.php" title="Combustible">
    Combustible
  </a>
</li>


  <li class="nav-item"><a class="nav-link <?php echo ($currentDir == 'places') ? 'active-link' : ''; ?>" href="/app/public/places/index.php">Lugares</a></li>
  <li class="nav-item"><a class="nav-link <?php echo ($currentDir == 'drivers') ? 'active-link' : ''; ?>" href="/app/public/drivers/index.php">Choferes</a></li>
  <li class="nav-item"><a class="nav-link <?php echo ($currentDir == 'customers') ? 'active-link' : ''; ?>" href="/app/public/customers/index.php">Clientes</a></li>
  <li class="nav-item"><a class="nav-link <?php echo ($currentFile == 'logs.php') ? 'active-link' : ''; ?>" href="/app/public/logs.php">Logs</a></li>
  <li class="nav-item"><a class="nav-link <?php echo ($currentFile == 'change.php') ? 'active-link' : ''; ?>" href="/app/public/change.php">Cambiar Contraseña</a></li>
  <li class="nav-item"><a class="nav-link <?php echo ($currentDir == 'users') ? 'active-link' : ''; ?>" href="/app/public/users/index.php">Usuarios</a></li>
</ul>


      <!-- Botón de logout -->
      <div class="d-flex align-items-center me-3">
        <a class="logout" href="/app/public/logout.php" style="color:rgba(255,255,255,0.85); text-decoration:none;">
          <i class="bi bi-box-arrow-right"></i> Cerrar Sesión
        </a>
      </div>
    </div>
  </div>
</nav>

<style>
  .logo-nav { height:34px; width:auto; }
  .navbar-dark .nav-link.active-link,
  .navbar-dark .nav-link:hover {
    color:#fff !important;
    background:rgba(255,255,255,0.1);
    border-radius:6px;
  }
</style>
<style>
  .logo-nav { height:34px; width:auto; }

  .navbar-dark .nav-link.active-link,
  .navbar-dark .nav-link:hover {
    color:#fff !important;
    background:rgba(255,255,255,0.1);
    border-radius:6px;
  }

  /* 🔧 Corrección visual para menú desplegable en móvil */
  @media (max-width: 991px) {
    .navbar-collapse {
      background-color: #1f2b35 !important; /* mismo color que la barra */
      padding: 10px;
      border-top: 1px solid rgba(255,255,255,0.1);
    }
    .navbar-nav .nav-link {
      color: #f1f1f1 !important;
      padding: 8px 12px;
    }
    .navbar-nav .nav-link:hover,
    .navbar-nav .nav-link.active-link {
      background: rgba(255,255,255,0.1);
      border-radius: 4px;
    }
  }
</style>