<?php
/**
 * helpers/functions.php
 * Funciones de uso común
 */

function redirect($url) {
    header("Location: $url");
    exit;
}

/**
 * Verifica si el usuario está logueado.
 * Usa ruta ABSOLUTA para evitar 404 en subcarpetas.
 */
function check_auth() {
    if (session_status() !== PHP_SESSION_ACTIVE) {
        session_start();
    }
    if (empty($_SESSION['user_id'])) {
        // IMPORTANTE: ruta absoluta al login de tu app
        redirect('/app/public/login.php');
    }
}